/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import com.mulesoft.agent.security.model.CryptographyAlgorithm;
import com.mulesoft.agent.security.model.KeyPairWrapper;
import com.mulesoft.agent.security.strategies.CryptographyStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public interface AgentSecurityManager {
    public boolean isFipsEnabled();

    public void initialize() throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchAlgorithmException;

    public CryptographyAlgorithm getCryptographyAlgorithm();

    public CryptographyStrategy getCryptographyStrategy();

    public PKCS10CertificationRequest generateAgentCertificateSigningRequest(KeyPairWrapper var1) throws OperatorCreationException, IOException;

    public String generateKeystorePassword();

    public KeyPairWrapper generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException;

    public InputStream transformCSRtoCertificate(InputStream var1) throws IOException;

    public InputStream transformCSRtoCertificate(String var1);
}

