/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mulesoft.agent.installer.EnvironmentInfo;
import com.mulesoft.agent.installer.ProxyInfo;
import com.mulesoft.agent.installer.ProxyKerberosInfo;
import com.mulesoft.agent.installer.coreservices.Credentials;
import com.mulesoft.agent.installer.utils.HTTPSUtilsInstaller;
import java.io.IOException;
import java.net.URL;
import javax.ws.rs.core.Response;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public class InstallerCoreServicesUtils {
    private static final int CS_TOKEN_LENGTH = 36;
    private static Gson GSON = new Gson();

    public static Credentials getCoreServicesUserInformation(EnvironmentInfo environmentInfo, ProxyInfo proxyInfo, ProxyKerberosInfo proxyKerberosInfo, String userAgent, String token, String orgId) throws Exception {
        String csToken = token.substring(0, 36);
        if (StringUtils.isBlank(orgId)) {
            throw new RuntimeException("Cannot retrieve organization information from Anypoint Platform. OrganizationId is not valid: " + orgId);
        }
        OkHttpClient httpClient = HTTPSUtilsInstaller.buildHTTPClient(proxyInfo, proxyKerberosInfo);
        URL url = new URL(environmentInfo.getCoreServicesUri() + "/api/organizations/" + orgId);
        httpClient = HTTPSUtilsInstaller.configureTLSIfSecureURL(httpClient, url, environmentInfo.isOnPrem());
        Request.Builder requestBuilder = new Request.Builder().url(url).header("User-Agent", userAgent).header("Accept-Language", "en-US,en;q=0.5").header("Content-Type", "application/json").header("Authorization", String.format("Bearer %s", csToken)).get();
        Response response = httpClient.newCall(requestBuilder.build()).execute();
        String clientId = InstallerCoreServicesUtils.getClientIdFromResponse(response);
        url = new URL(String.format("%s/api/organizations/%s/clients/%s", environmentInfo.getCoreServicesUri(), orgId, clientId));
        httpClient = HTTPSUtilsInstaller.configureTLSIfSecureURL(httpClient, url, environmentInfo.isOnPrem());
        if (environmentInfo.isOnPrem()) {
            httpClient = httpClient.newBuilder().hostnameVerifier((hostname, sslSession) -> true).build();
        }
        requestBuilder = new Request.Builder().url(url).header("User-Agent", userAgent).header("Accept-Language", "en-US,en;q=0.5").header("Content-Type", "application/json").header("Authorization", String.format("Bearer %s", csToken)).get();
        response = httpClient.newCall(requestBuilder.build()).execute();
        String clientSecret = InstallerCoreServicesUtils.getClientSecretFromResponse(response);
        return new Credentials(orgId, clientId, clientSecret);
    }

    private static String getClientSecretFromResponse(Response response) throws IOException {
        String responseBody = null;
        if (response.code() != Response.Status.OK.getStatusCode()) {
            if (response.code() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                System.out.printf("%nThe token provided is not valid %n", new Object[0]);
            } else {
                System.out.printf("%nAn error occurred while getting user information: " + response.code() + "%n", new Object[0]);
            }
            throw new RuntimeException("Cannot get Client Secret information from Organization");
        }
        responseBody = response.body().string();
        if (responseBody == null) {
            throw new RuntimeException("Cannot get Client Secret information from Organization");
        }
        String clientId = GSON.fromJson(responseBody, JsonElement.class).getAsJsonObject().get("client_secret").getAsString();
        return clientId;
    }

    private static String getClientIdFromResponse(Response response) throws IOException {
        String responseBody = null;
        if (response.code() != Response.Status.OK.getStatusCode()) {
            if (response.code() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                System.out.printf("%nThe token provided is not valid %n", new Object[0]);
            } else {
                System.out.printf("%nAn error occurred while getting user and organization information: " + response.code() + "%n", new Object[0]);
            }
            throw new RuntimeException("Cannot get Client ID information from Organization");
        }
        responseBody = response.body().string();
        if (responseBody == null) {
            throw new RuntimeException("Cannot get Client ID information from Organization");
        }
        String clientId = GSON.fromJson(responseBody, JsonElement.class).getAsJsonObject().get("clientId").getAsString();
        return clientId;
    }
}

