/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;

public class InstallerCertificateUtils {
    public static final String KEYSTORE_FILE = "mule-agent.jks";
    public static final String TRUSTSTORE_FILE = "anypoint-truststore.jks";
    public static final String OLD_TRUSTSTORE_FILE = "truststore.jks";

    public static boolean validateKeystoreAlias(File keystoreFile, String keystorePassword, String keystoreAlias, String keystoreAliasPassword) {
        KeyStore keystore;
        try {
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream keystoreFileStream = new FileInputStream(keystoreFile);){
                keystore.load(keystoreFileStream, keystorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            System.out.println("Could not load keystore. Please check the location is right, it is under JKS format and the password is correct");
            return false;
        }
        try {
            keystore.getKey(keystoreAlias, keystoreAliasPassword.toCharArray());
        }
        catch (Exception e) {
            System.out.println("Could not validate keystoreAlias. Please check if the alias and the password are correct");
            return false;
        }
        return true;
    }
}

