/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.utils;

import com.mulesoft.agent.installer.ProxyInfo;
import com.mulesoft.agent.installer.ProxyKerberosInfo;
import com.mulesoft.agent.util.InstallerLoggingUtils;
import com.mulesoft.transport.security.proxy.OkHttpProxyConfigurator;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class HTTPSUtilsInstaller {
    private static final String TLS_VERSION = "TLSv1.2";
    private static final Integer DEFAULT_PROXY_PORT_NUMBER = 8080;

    @NotNull
    public static Integer getPortNumber(String portStr) {
        String port = portStr;
        if (port == null) {
            port = "";
        }
        Integer portNumber = 8080;
        try {
            portNumber = Integer.parseInt(port.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return portNumber;
    }

    @NotNull
    public static OkHttpClient configureTLSIfSecureURL(OkHttpClient httpClient, URL url, boolean isOnPrem) throws NoSuchAlgorithmException, KeyManagementException {
        if (!HTTPSUtilsInstaller.isHttpsURL(url)) {
            return httpClient;
        }
        SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
        if (isOnPrem) {
            return HTTPSUtilsInstaller.configureOkHttpClientWithTrustAllCerts(httpClient, sslContext);
        }
        sslContext.init(null, new TrustManager[]{httpClient.x509TrustManager()}, null);
        return httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), httpClient.x509TrustManager()).build();
    }

    @NotNull
    public static OkHttpClient buildHTTPClient(ProxyInfo proxyInfo, ProxyKerberosInfo proxyKerberosInfo) {
        Integer portNumber = DEFAULT_PROXY_PORT_NUMBER;
        if (proxyInfo == null) {
            proxyInfo = ProxyInfo.DEFAULT;
        } else {
            portNumber = HTTPSUtilsInstaller.getPortNumber(proxyInfo.getPort());
        }
        if (proxyKerberosInfo == null) {
            proxyKerberosInfo = ProxyKerberosInfo.DEFAULT;
        }
        ProxyAuthConfiguration proxyAuthConfiguration = new ProxyAuthConfiguration(proxyInfo.getHost(), portNumber, proxyInfo.getUser(), proxyInfo.getPassword(), proxyInfo.isTrafficInspectionEnabled(), proxyKerberosInfo.getKrb5ConfigurationPath(), proxyKerberosInfo.getJaasConfigurationPath());
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        httpClientBuilder = new OkHttpProxyConfigurator(InstallerLoggingUtils::info).configure(httpClientBuilder, proxyAuthConfiguration);
        return httpClientBuilder.build();
    }

    @NotNull
    private static OkHttpClient configureOkHttpClientWithTrustAllCerts(OkHttpClient httpClient, SSLContext sslContext) throws KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        sslContext.init(null, trustAllCerts, null);
        return httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]).hostnameVerifier((hostname, sslSession) -> true).build();
    }

    private static boolean isHttpsURL(URL url) {
        return url.getProtocol().compareToIgnoreCase("https") == 0;
    }
}

