/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.response;

import com.mulesoft.agent.installer.response.EnvironmentUrls;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;

public class RegistrationResponse {
    private String clientId;
    private String clientSecret;
    private String certificate;
    private String caCertificate;
    private String[] chainCertificates;
    private EnvironmentUrls environmentUrls = new EnvironmentUrls();
    private String envId;
    private String orgId;
    private boolean legacyRegistration = false;
    private InputStream certificateIS;

    public RegistrationResponse() {
    }

    public RegistrationResponse(String clientId, String clientSecret, String certificate) {
        this(clientId, clientSecret, certificate, null);
    }

    public RegistrationResponse(String clientId, String clientSecret, String certificate, String caCertificate) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.certificate = certificate;
        this.caCertificate = caCertificate;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public boolean isLegacyRegistration() {
        return this.legacyRegistration;
    }

    public void setLegacyRegistration(boolean legacyRegistration) {
        this.legacyRegistration = legacyRegistration;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public EnvironmentUrls getEnvironmentUrls() {
        return this.environmentUrls;
    }

    public InputStream getCertificateIS() {
        return this.certificateIS;
    }

    public void setCertificateIS(InputStream certificateIS) {
        this.certificateIS = certificateIS;
    }

    public void setEnvironmentUrls(EnvironmentUrls environmentUrls) {
        this.environmentUrls = environmentUrls;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public void setCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
    }

    public InputStream getCertificateISorElseBuild() {
        return this.getCertificateIS() != null ? this.getCertificateIS() : this.buildAgentCertificateInputStream();
    }

    public InputStream getNullableCaCertificateIS() {
        return this.getCaCertificate() != null ? this.buildCACertificateInputStream() : null;
    }

    public InputStream[] getNullableChainCertificatesIS() {
        if (this.getChainCertificates() == null || this.getChainCertificates().length == 0) {
            return null;
        }
        InputStream[] chainCertsIS = new InputStream[this.getChainCertificates().length];
        IntStream.range(0, this.getChainCertificates().length).forEach(idx -> {
            chainCertsIS[idx] = new ByteArrayInputStream(this.getChainCertificates()[idx].getBytes(StandardCharsets.UTF_8));
        });
        return chainCertsIS;
    }

    private ByteArrayInputStream buildCACertificateInputStream() {
        return new ByteArrayInputStream(this.getCaCertificate().getBytes(StandardCharsets.UTF_8));
    }

    private ByteArrayInputStream buildAgentCertificateInputStream() {
        return new ByteArrayInputStream(this.getCertificate().getBytes(StandardCharsets.UTF_8));
    }

    public String[] getChainCertificates() {
        return this.chainCertificates;
    }

    public void setChainCertificates(String[] chainCertificates) {
        this.chainCertificates = chainCertificates;
    }

    public String toString() {
        return "RegistrationResponse{clientId='" + this.clientId + '\'' + ", clientSecret='*******************', certificate='" + this.certificate + '\'' + ", environmentUrls=" + this.environmentUrls + ", envId='" + this.envId + '\'' + ", orgId='" + this.orgId + '\'' + ", legacyRegistration=" + this.legacyRegistration + '}';
    }
}

