/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.request;

import com.google.gson.Gson;
import com.mulesoft.agent.installer.ProxyInfo;
import com.mulesoft.agent.installer.ProxyKerberosInfo;
import com.mulesoft.agent.installer.request.RegistrationRequestBody;
import com.mulesoft.agent.installer.response.RegistrationResponse;
import com.mulesoft.agent.installer.utils.HTTPSUtilsInstaller;
import com.mulesoft.agent.security.AgentSecurityManagerBuilder;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.ws.rs.core.Response;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class HybridRegistrationRequest {
    private static final String ANYPNT_ENVIRONMENT_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ANYPNT_ORGANIZATION_HEADER = "X-ANYPNT-ORG-ID";
    private String consoleUri;
    private String authorizationToken;
    private RegistrationRequestBody registrationRequest;
    private String userAgent;
    private ProxyKerberosInfo proxyKerberosInfo;
    private ProxyInfo proxyInfo;
    private boolean isOnPrem;
    private static Gson GSON = new Gson();

    private HybridRegistrationRequest(String consoleUri, String authorizationToken) {
        this.consoleUri = consoleUri;
        this.authorizationToken = authorizationToken;
    }

    public static HybridRegistrationRequest create(String consoleUri, String authorizationToken) {
        return new HybridRegistrationRequest(consoleUri, authorizationToken);
    }

    public HybridRegistrationRequest withRegistrationRequest(RegistrationRequestBody registrationRequest) {
        this.registrationRequest = registrationRequest;
        return this;
    }

    public HybridRegistrationRequest withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HybridRegistrationRequest withProxy(ProxyInfo proxyInfo, ProxyKerberosInfo proxyKerberosInfo) {
        this.proxyInfo = proxyInfo;
        this.proxyKerberosInfo = proxyKerberosInfo;
        return this;
    }

    public HybridRegistrationRequest withIsOnPrem(boolean isOnPrem) {
        this.isOnPrem = isOnPrem;
        return this;
    }

    public RegistrationResponse post() throws IOException, NoSuchAlgorithmException, KeyManagementException, IllegalArgumentException, CertificateException, KeyStoreException {
        OkHttpClient httpClient = HTTPSUtilsInstaller.buildHTTPClient(this.proxyInfo, this.proxyKerberosInfo);
        URL url = new URL(String.format("%s/%s", this.consoleUri, "servers"));
        System.out.println(String.format("%nSending Sign request to Anypoint Management Center ", new Object[0]));
        Response response = this.doRequest(httpClient, url, false);
        HybridRegistrationRequest.validateStatusCode(response);
        if (response.code() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
            Response retryResponse = this.doRequest(httpClient, url, true);
            HybridRegistrationRequest.validateStatusCode(retryResponse);
            RegistrationResponse registrationResponse = new RegistrationResponse();
            registrationResponse.setEnvId(retryResponse.header(ANYPNT_ENVIRONMENT_HEADER));
            registrationResponse.setOrgId(retryResponse.header(ANYPNT_ORGANIZATION_HEADER));
            registrationResponse.setCertificateIS(retryResponse.body().byteStream());
            registrationResponse.setLegacyRegistration(Boolean.TRUE);
            return registrationResponse;
        }
        String content = IOUtils.toString(response.body().byteStream());
        response.body().byteStream().close();
        return GSON.fromJson(content, RegistrationResponse.class);
    }

    @NotNull
    private Response doRequest(OkHttpClient httpClient, URL url, boolean isLegacyRegistration) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateException, KeyStoreException {
        httpClient = HTTPSUtilsInstaller.configureTLSIfSecureURL(httpClient, url, this.isOnPrem);
        boolean isFipsEnabled = AgentSecurityManagerBuilder.newInstance().useFipsConfigurationProperty().build().isFipsEnabled();
        if (isFipsEnabled) {
            httpClient = httpClient.newBuilder().hostnameVerifier((hostname, sslSession) -> true).build();
        }
        Request.Builder requestBuilder = new Request.Builder().header("User-Agent", this.userAgent).header("Accept-Language", "en-US,en;q=0.5").header("Content-Type", "application/json").header("Authorization", String.format("Bearer %s", this.authorizationToken));
        if (!isLegacyRegistration) {
            requestBuilder.header("Accept", "application/json");
        }
        RequestBody body = RequestBody.create(MediaType.parse("application/json"), GSON.toJson(this.registrationRequest));
        requestBuilder.url(url).post(body);
        Response response = httpClient.newCall(requestBuilder.build()).execute();
        return response;
    }

    private static int validateStatusCode(Response response) throws IllegalArgumentException, IOException {
        int responseCode = response.code();
        if (responseCode == Response.Status.OK.getStatusCode()) {
            System.out.println("Mule Agent configured successfully");
        } else {
            if (responseCode == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new IllegalArgumentException("Could not authenticate with the provided token");
            }
            if (responseCode == Response.Status.CONFLICT.getStatusCode()) {
                throw new IllegalArgumentException("The server name is already registered for this organization. Please register again using a different server name.");
            }
            if (responseCode == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
                System.out.println("Detected Legacy Registration with Hybrid. Retrying request.");
            } else {
                String message = HybridRegistrationRequest.parseErrorMessage(response.body().string());
                response.body().close();
                throw new IllegalArgumentException(String.format("The hybrid console returned error code %s: %s", responseCode, message));
            }
        }
        return responseCode;
    }

    private static String parseErrorMessage(String content) {
        String message;
        String MESSAGE_KEY = "message";
        try {
            Map response = GSON.fromJson(content, Map.class);
            message = response.containsKey("message") ? (String)response.get("message") : "Missing response message";
        }
        catch (Exception e) {
            System.out.println("An error occurred executing the Mule Agent Configuration; message parsing error");
            return content;
        }
        return message;
    }
}

