/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator.migrations;

import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Named(value="RestSecurityMigration")
@Singleton
public class RestSecurityMigration
extends DescriptorMigration {
    private static final String TRANSPORTS_KEY = "transports";
    private static final String REST_TRANSPORT_KEY = "rest.agent.transport";
    private static final String OLD_SECURITY_KEY = "security";
    private static final String NEW_SECURITY_KEY = "restSecurity";

    @Override
    public Long getTimestamp() {
        return 1471023003783L;
    }

    @Override
    public boolean isApplicable(String oldVersion) {
        ComparableVersion minimumVersion = new ComparableVersion("1.5.1");
        return minimumVersion.compareTo(new ComparableVersion(oldVersion)) > 0;
    }

    @Override
    public Map migrate(Map configuration) {
        Map transportsConfigurations = (Map)configuration.get(TRANSPORTS_KEY);
        if (transportsConfigurations == null) {
            return configuration;
        }
        Map restTransportConfiguration = (Map)transportsConfigurations.get(REST_TRANSPORT_KEY);
        if (restTransportConfiguration == null) {
            return configuration;
        }
        Map securityConfiguration = (Map)restTransportConfiguration.get(OLD_SECURITY_KEY);
        if (securityConfiguration == null) {
            return configuration;
        }
        restTransportConfiguration.remove(OLD_SECURITY_KEY);
        restTransportConfiguration.put(NEW_SECURITY_KEY, securityConfiguration);
        return configuration;
    }
}

