/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator.migrations;

import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Named(value="ProxyConfigurationMigration")
@Singleton
public class ProxyConfigurationMigration
extends DescriptorMigration {
    private static final String TRANSPORTS_KEY = "transports";
    private static final String GLOBAL_CONFIGURATION_KEY = "globalConfiguration";
    private static final String WEBSOCKET_TRANSPORT_KEY = "websocket.transport";
    private static final String PROXY_CONFIGURATION_KEY = "proxyConfiguration";
    private static final String PROXY_KERBEROS_CONFIGURATION_KEY = "proxyKerberosConfiguration";

    @Override
    public Long getTimestamp() {
        return 1470343560275L;
    }

    @Override
    public boolean isApplicable(String oldVersion) {
        ComparableVersion minimumVersion = new ComparableVersion("1.5.1");
        return minimumVersion.compareTo(new ComparableVersion(oldVersion)) > 0;
    }

    @Override
    public Map migrate(Map configuration) {
        Map websocketConfiguration = (Map)((Map)configuration.get(TRANSPORTS_KEY)).get(WEBSOCKET_TRANSPORT_KEY);
        if (websocketConfiguration == null) {
            return configuration;
        }
        this.patchConfiguration(configuration, websocketConfiguration, PROXY_CONFIGURATION_KEY);
        this.patchConfiguration(configuration, websocketConfiguration, PROXY_KERBEROS_CONFIGURATION_KEY);
        return configuration;
    }

    private void patchConfiguration(Map configuration, Map websocketConfiguration, String configurationKey) {
        Map sourceConfiguration = (Map)websocketConfiguration.get(configurationKey);
        if (sourceConfiguration != null && !sourceConfiguration.isEmpty()) {
            if (configuration.get(GLOBAL_CONFIGURATION_KEY) == null) {
                configuration.put(GLOBAL_CONFIGURATION_KEY, new HashMap());
            }
            ((Map)configuration.get(GLOBAL_CONFIGURATION_KEY)).put(configurationKey, sourceConfiguration);
            websocketConfiguration.remove(configurationKey);
        }
    }
}

