/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator.migrations;

import com.google.common.collect.Lists;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Named(value="OnPremEnvironmentSetterMigration")
@Singleton
public class OnPremEnvironmentSetterMigration
extends DescriptorMigration {
    private static final String TRANSPORTS_KEY = "transports";
    private static final String WEBSOCKET_TRANSPORT_KEY = "websocket.transport";
    private static final String MCM_CONFIGURATION_KEY = "consoleUri";
    private static final List<String> KNOWN_MCM_URIS = Lists.newArrayList("wss://hybrid-mcm.dev.cloudhub.io:443/mule", "wss://localhost:8443/mule", "wss://hybrid-mcm-performance.qa2.cloudhub.io:443/mule", "wss://hybrid-mcm.qa2.cloudhub.io:443/mule", "wss://hybrid-mcm.stg.cloudhub.io:443/mule", "wss://mule-manager.stgx.anypoint.mulesoft.com:443/mule", "wss://mule-manager.uat.anypoint.mulesoft.com:443/mule", "wss://mule-manager.anypoint.mulesoft.com:443/mule");

    @Override
    public Long getTimestamp() {
        return 1474801907258L;
    }

    @Override
    public boolean isApplicable(String oldVersion) {
        ComparableVersion minimumVersion = new ComparableVersion("1.5.2");
        return minimumVersion.compareTo(new ComparableVersion(oldVersion)) > 0;
    }

    @Override
    public Map migrate(Map configuration) {
        Map transportsConfigurations = (Map)configuration.get(TRANSPORTS_KEY);
        if (transportsConfigurations == null) {
            return configuration;
        }
        Map webSocketConfiguration = (Map)transportsConfigurations.get(WEBSOCKET_TRANSPORT_KEY);
        if (webSocketConfiguration == null) {
            return configuration;
        }
        String mcmUri = (String)webSocketConfiguration.get(MCM_CONFIGURATION_KEY);
        if (StringUtils.isBlank(mcmUri)) {
            return configuration;
        }
        if (!KNOWN_MCM_URIS.contains(mcmUri)) {
            configuration.put("environment", RuntimeEnvironment.ON_PREM.getValue());
        }
        return configuration;
    }
}

