/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator.migrations;

import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Named(value="ExtractSecurityMigration")
@Singleton
public class ExtractSecurityMigration
extends DescriptorMigration {
    private static final String TRANSPORTS_KEY = "transports";
    private static final String GLOBAL_CONFIGURATION_KEY = "globalConfiguration";
    private static final String WEBSOCKET_TRANSPORT_KEY = "websocket.transport";
    private static final String SECURITY_KEY = "security";
    private static final String HANDSHAKE = "handshake";

    @Override
    public Long getTimestamp() {
        return 1465332120L;
    }

    @Override
    public boolean isApplicable(String oldVersion) {
        ComparableVersion minimumVersion = new ComparableVersion("1.5.0");
        return minimumVersion.compareTo(new ComparableVersion(oldVersion)) > 0;
    }

    @Override
    public Map migrate(Map configuration) {
        Map websocketConfiguration = (Map)((Map)configuration.get(TRANSPORTS_KEY)).get(WEBSOCKET_TRANSPORT_KEY);
        Map securityConfiguration = (Map)websocketConfiguration.get(SECURITY_KEY);
        Map handshake2 = (Map)securityConfiguration.get(HANDSHAKE);
        websocketConfiguration.put(HANDSHAKE, handshake2);
        securityConfiguration.remove(HANDSHAKE);
        websocketConfiguration.remove(SECURITY_KEY);
        configuration.put(GLOBAL_CONFIGURATION_KEY, new HashMap());
        ((Map)configuration.get(GLOBAL_CONFIGURATION_KEY)).put(SECURITY_KEY, securityConfiguration);
        return configuration;
    }
}

