/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator.migrations;

import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import com.mulesoft.agent.installer.migrator.migrations.exception.DiskBufferingMigrationException;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Named(value="DiskBufferingMigration")
@Singleton
public class DiskBufferingMigration
extends DescriptorMigration {
    private static final long TIMESTAMP = 1496697396196L;
    private static final String BUFFER_KEY = "buffer";
    private static final String FILE_PATH_KEY = "filePath";

    @Override
    public Long getTimestamp() {
        return 1496697396196L;
    }

    @Override
    public boolean isApplicable(String oldVersion) {
        ComparableVersion minimumVersion = new ComparableVersion("1.7.1");
        return minimumVersion.compareTo(new ComparableVersion(oldVersion)) > 0;
    }

    @Override
    public Map migrate(Map configuration) {
        List<String> filePaths = this.getDiskBufferFilesInUse(configuration);
        if (!filePaths.isEmpty()) {
            throw new DiskBufferingMigrationException(InstallerMessages.removeOldDiskBufferMessage(filePaths));
        }
        return configuration;
    }

    public List<String> getDiskBufferFilesInUse(Map<String, Object> configuration) {
        LinkedList<String> filePaths = new LinkedList<String>();
        for (String bufferFile : this.getBufferFiles(configuration)) {
            File file = new File(bufferFile);
            if (!file.exists() || !file.isFile()) continue;
            filePaths.add(bufferFile);
        }
        return filePaths;
    }

    public List<String> getBufferFiles(Map<String, Object> values2) {
        LinkedList<String> bufferFiles = new LinkedList<String>();
        for (String key : values2.keySet()) {
            Object value = values2.get(key);
            if (!(value instanceof Map)) continue;
            if (key.equals(BUFFER_KEY) && ((Map)value).containsKey(FILE_PATH_KEY)) {
                bufferFiles.add((String)((Map)value).get(FILE_PATH_KEY));
                continue;
            }
            bufferFiles.addAll(this.getBufferFiles((Map)value));
        }
        return bufferFiles;
    }
}

