/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator.migrations;

import com.mulesoft.agent.installer.EnvironmentInfo;
import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Named(value="CreateAuthenticationProxyConfigurationMigration")
@Singleton
public class CreateAuthenticationProxyConfigurationMigration
extends DescriptorMigration {
    private static final String AUTH_PROXY_ENDPOINT_KEY = "endpoint";
    private static final String AUTH_PROXY_CONFIGURATION_KEY = "authenticationProxy";
    private static final String GLOBAL_CONFIGURATION_KEY = "globalConfiguration";
    @Inject
    private EnvironmentInfo environmentInfo;

    @Override
    public Long getTimestamp() {
        return 1466625202356L;
    }

    @Override
    public boolean isApplicable(String oldVersion) {
        ComparableVersion minimumVersion = new ComparableVersion("1.5.0");
        return minimumVersion.compareTo(new ComparableVersion(oldVersion)) > 0;
    }

    @Override
    public Map migrate(Map configuration) {
        Map globalConfiguration = (Map)configuration.get(GLOBAL_CONFIGURATION_KEY);
        HashMap<String, String> authProxyConfiguration = new HashMap<String, String>();
        authProxyConfiguration.put(AUTH_PROXY_ENDPOINT_KEY, this.environmentInfo.getAuthServicesUri());
        globalConfiguration.put(AUTH_PROXY_CONFIGURATION_KEY, authProxyConfiguration);
        return configuration;
    }
}

