/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.migrator;

import com.mulesoft.agent.installer.MuleAgentYaml;
import com.mulesoft.agent.installer.migrator.DescriptorMigration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="DescriptorMigrator")
@Singleton
public class DescriptorMigrator {
    @Inject
    List<DescriptorMigration> descriptorMigrations;

    public void migrate(File descriptorFile, String oldVersion) {
        try {
            MuleAgentYaml yamlHandler = MuleAgentYaml.newInstance(descriptorFile);
            Map configuration = yamlHandler.getRaw();
            ArrayList<DescriptorMigration> sortedMigrations = new ArrayList<DescriptorMigration>(this.descriptorMigrations);
            Collections.sort(sortedMigrations);
            for (DescriptorMigration descriptorMigration : sortedMigrations) {
                if (descriptorMigration.isApplicable(oldVersion)) {
                    configuration = descriptorMigration.migrate(configuration);
                    System.out.println("Applying migration " + descriptorMigration.getClass() + " to the Mule Agent descriptor.");
                    continue;
                }
                System.out.println("Skipping migration " + descriptorMigration.getClass());
            }
            yamlHandler.dumpUpdate(configuration);
        }
        catch (IOException e) {
            System.out.println("Error while processing descriptor file for update");
            e.printStackTrace();
        }
    }
}

