/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.keystore;

import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.security.model.KeyPairWrapper;
import com.mulesoft.agent.security.model.KeystoreType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

public class KeyStoreUtils {
    private static final String JKS_INSTANCE = "JKS";
    private static final String X_509_INSTANCE = "X.509";
    private static final String PEM_CERTIFICATE_START = "BEGIN CERTIFICATE";
    private static final String PEM_CERTIFICATE_END = "END CERTIFICATE";
    private static final String KEYSTORE_FILE = "mule-agent.jks";
    public static final String NEW_ALIAS_FORMAT = "%s%s_%s";
    private static final String DATE_FORMAT = "YYYY-MM-dd_hh-mm-ss";
    private static final String FILE_BACKUP_FORMAT = "%s.%s";

    public static KeyStore loadDefaultTrustStore(String folderPath, String keystorePassword, String keystoreType) {
        String trustStoreFilePath = folderPath + "/" + "anypoint-truststore.jks";
        return KeyStoreUtils.loadKeyStore(trustStoreFilePath, keystorePassword, keystoreType);
    }

    public static KeyStore loadDefaultKeyStore(String folderPath, String keystorePassword, String keyStoreType) {
        KeyStore ks;
        block2: {
            String keystoreFilePath = folderPath + "/" + KEYSTORE_FILE;
            ks = null;
            try {
                ks = KeyStoreUtils.loadKeyStore(keystoreFilePath, keystorePassword, keyStoreType);
            }
            catch (Exception e) {
                if (!keyStoreType.equalsIgnoreCase(KeystoreType.FIPS.toString())) break block2;
                ks = KeyStoreUtils.loadKeyStore(keystoreFilePath, keystorePassword, KeystoreType.PKCS12.toString());
            }
        }
        return ks;
    }

    public static Certificate loadDefaultCertificate(String folderPath, String keystorePassword, String keystoreType, String alias) throws KeyStoreException {
        KeyStore keystore = KeyStoreUtils.loadDefaultKeyStore(folderPath, keystorePassword, keystoreType);
        return keystore.getCertificate(alias);
    }

    public static boolean importOnPremTrustStores(String folderPath, String pemContent, String keystorePassword, String keystoreType) throws Exception {
        KeyStore trustStore = KeyStoreUtils.loadDefaultTrustStore(folderPath, keystorePassword, keystoreType);
        String trustStoreFilePath = folderPath + "/" + "anypoint-truststore.jks";
        return KeyStoreUtils.importCertificatesToKeyStore(trustStore, keystorePassword, trustStoreFilePath, pemContent, "onprem");
    }

    private static boolean importCertificatesToKeyStore(KeyStore keyStore, String keystorePassword, String keyStoreFilePath, String pemContent, String alias) throws Exception {
        List<X509Certificate> certificatesInPem = KeyStoreUtils.loadCertificatesFromPEM(pemContent);
        List<X509Certificate> certificatesInKeyStore = KeyStoreUtils.getAllCertificates(keyStore);
        int certsAdded = 0;
        String uniqueSequence = String.valueOf(System.currentTimeMillis());
        for (X509Certificate certificate : certificatesInPem) {
            BigInteger serialNumber = certificate.getSerialNumber();
            if (certificatesInKeyStore.stream().noneMatch(cert -> cert.getSerialNumber().equals(serialNumber))) {
                String newAlias = String.format(NEW_ALIAS_FORMAT, alias, uniqueSequence, ++certsAdded);
                keyStore.setCertificateEntry(newAlias, certificate);
                InstallerUtils.info(String.format("Added certificate to the truststore with alias %s", newAlias));
                continue;
            }
            InstallerUtils.info(String.format("Serial number already exists in the truststore, skipping: %s", serialNumber));
        }
        if (certsAdded > 0) {
            try (FileOutputStream fos = new FileOutputStream(keyStoreFilePath);){
                keyStore.store(fos, keystorePassword.toCharArray());
            }
        }
        return certsAdded > 0;
    }

    public static List<X509Certificate> getAllCertificates(KeyStore keyStore) throws Exception {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = keyStore.getCertificate(alias);
            if (!(certificate instanceof X509Certificate)) continue;
            certificates.add((X509Certificate)certificate);
        }
        return certificates;
    }

    public static List<X509Certificate> loadCertificatesFromPEM(String pemContent) throws CertificateException, IOException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509_INSTANCE);
        try (BufferedReader reader = new BufferedReader(new StringReader(pemContent));){
            String line;
            StringBuilder certBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.contains(PEM_CERTIFICATE_START)) {
                    certBuilder = new StringBuilder();
                }
                certBuilder.append(line).append(System.lineSeparator());
                if (!line.contains(PEM_CERTIFICATE_END)) continue;
                ByteArrayInputStream certStream = new ByteArrayInputStream(certBuilder.toString().getBytes());
                X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(certStream);
                certificates.add(cert);
            }
        }
        return certificates;
    }

    public static KeyStore loadKeyStore(String keystoreFilePath, String keystorePassword, String keystoreType) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(keystoreType);
        }
        catch (KeyStoreException e) {
            InstallerUtils.error("Error trying to get the Keystore Instance");
            throw new RuntimeException(e);
        }
        try (FileInputStream keyStoreFile = new FileInputStream(keystoreFilePath);){
            keyStore.load(keyStoreFile, keystorePassword.toCharArray());
        }
        catch (FileNotFoundException e) {
            InstallerUtils.error(String.format("Error trying to get the Keystore file %s", keystoreFilePath));
            throw new RuntimeException(e);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(String keystoreFilePath, String keystorePassword) {
        return KeyStoreUtils.loadKeyStore(keystoreFilePath, keystorePassword, JKS_INSTANCE);
    }

    public static void backupJKS(File confFolder) throws IOException {
        System.out.println("INFO: Backing up current agent keystore.");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date date = new Date();
        String dateSuffix = dateFormat.format(date);
        Path keystorePath = Paths.get(confFolder.getPath() + File.separator + KEYSTORE_FILE, new String[0]);
        Path keystoreBackup = Paths.get(String.format(FILE_BACKUP_FORMAT, confFolder + File.separator + KEYSTORE_FILE, dateSuffix), new String[0]);
        Files.copy(keystorePath, keystoreBackup, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void generateJKS(File confFolder, InputStream certificateInputStream, KeyPairWrapper keyPairWrapper, char[] keystorePassword, String getKeystoreTypeName, String alias) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        System.out.println("INFO: Generating and saving new keystore.");
        Certificate certificate = CertificateFactory.getInstance(X_509_INSTANCE).generateCertificate(certificateInputStream);
        KeyStore keyStore = KeyStore.getInstance(getKeystoreTypeName);
        keyStore.load(null, keystorePassword);
        Certificate[] certChain = new Certificate[]{certificate};
        keyStore.setKeyEntry(alias, keyPairWrapper.getPrivateKey(), keystorePassword, certChain);
        FileOutputStream keystoreFile = new FileOutputStream(new File(confFolder, KEYSTORE_FILE));
        keyStore.store(keystoreFile, keystorePassword);
        keystoreFile.close();
    }

    /*
     * Exception decompiling
     */
    public static String toPem(Object object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

