/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.keystore;

import com.mulesoft.agent.installer.HybridInstaller;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.installer.keystore.DefaultKeyStoreStrategy;
import com.mulesoft.agent.installer.keystore.HybridKeyStoreStrategy;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.security.model.AgentSecurityProvider;
import com.mulesoft.agent.security.model.KeyPairWrapper;
import com.mulesoft.agent.security.strategies.CryptographyStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;

public abstract class KeyStoreStrategy {
    protected static final String CLOUD_CERTIFICATE_ALIAS = "hybrid";
    protected static final String CLOUD_CERTIFICATE_ALIAS_LEGACY = "tomcat";
    protected static final String PCE_CERTIFICATE_ALIAS = "onprem";
    protected static final String AGENT_CERTIFICATE_ALIAS = "agent";
    private File keystoreFile;
    private Certificate[] chainCertificates;
    private Certificate agentCertificate;
    private Certificate caCertificate;
    private File defaultTrustStoreFile;
    private String builtInTruststoreFilename;
    private KeyStore keyStore;
    private String keystoreType;
    private boolean onPrem;
    private boolean isHyperforce;

    protected KeyStoreStrategy(File keystoreFile, Certificate agentCertificate, File defaultTrustStoreFile, String previousTrustStoreFilename, boolean onPrem, boolean isHyperforce, Certificate[] agentChainCertificates, String keystoreType) {
        this(keystoreFile, agentCertificate, defaultTrustStoreFile, previousTrustStoreFilename, null, onPrem, isHyperforce, agentChainCertificates, keystoreType);
    }

    protected KeyStoreStrategy(File keystoreFile, Certificate agentCertificate, File defaultTrustStoreFile, String builtInTruststoreFilename, Certificate caCertificate, boolean onPrem, boolean isHyperforce, Certificate[] agentChainCertificates, String keystoreType) {
        this.keystoreFile = keystoreFile;
        this.agentCertificate = agentCertificate;
        this.defaultTrustStoreFile = defaultTrustStoreFile;
        this.builtInTruststoreFilename = builtInTruststoreFilename;
        this.caCertificate = caCertificate;
        this.onPrem = onPrem;
        this.isHyperforce = isHyperforce;
        this.keystoreType = keystoreType;
        this.chainCertificates = agentChainCertificates;
    }

    protected ByteArrayOutputStream copyTrustStoreFileAndGet() throws Exception {
        String filename = this.builtInTruststoreFilename;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream resourceStream = HybridInstaller.class.getClassLoader().getResourceAsStream(filename);
        IOUtils.copy(resourceStream, (OutputStream)baos);
        resourceStream.close();
        return baos;
    }

    protected File getDefaultTrustStoreFile() {
        return this.defaultTrustStoreFile;
    }

    protected Certificate getCaCertificate() {
        return this.caCertificate;
    }

    protected boolean isOnPrem() {
        return this.onPrem;
    }

    protected void buildKeyStore(KeyPairWrapper keyPairWrapper, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.agentCertificate == null) {
            return;
        }
        this.keyStore = KeyStore.getInstance(this.keystoreType);
        this.keyStore.load(null, password);
        Certificate[] certChain = this.getRuntimeCertificates();
        this.keyStore.setKeyEntry(AGENT_CERTIFICATE_ALIAS, keyPairWrapper.getPrivateKey(), password, certChain);
        FileOutputStream keystoreFOS = new FileOutputStream(this.keystoreFile);
        this.keyStore.store(keystoreFOS, password);
        keystoreFOS.close();
    }

    private Certificate[] getRuntimeCertificates() {
        if (this.chainCertificates != null && this.chainCertificates.length > 0) {
            Certificate[] certChain = new Certificate[this.chainCertificates.length];
            IntStream.range(0, this.chainCertificates.length).forEach(idx -> {
                certChain[idx] = this.chainCertificates[idx];
            });
            return certChain;
        }
        Certificate[] certChain = new Certificate[]{this.agentCertificate};
        return certChain;
    }

    protected KeyStore buildTrustStore(char[] password) throws Exception {
        KeyStore truststore = KeyStore.getInstance(this.keystoreType);
        ByteArrayInputStream trustStoreInputStream = new ByteArrayInputStream(this.copyTrustStoreFileAndGet().toByteArray());
        truststore.load(trustStoreInputStream, FipsUtils.getTrustStorePassword(this.keystoreType, password));
        trustStoreInputStream.close();
        return truststore;
    }

    private void save(KeyStore keyStore, File file, char[] password) throws Exception {
        FileOutputStream truststoreFOS = new FileOutputStream(file);
        keyStore.store(truststoreFOS, password);
    }

    public void generateJKS(KeyPairWrapper keyPairWrapper, char[] password) throws Exception {
        this.buildKeyStore(keyPairWrapper, password);
        if (!this.isHyperforce) {
            this.generateTrustStoreJKS(password);
        }
    }

    public void generateTrustStoreJKS(char[] password) throws Exception {
        KeyStore trustStore = this.buildTrustStore(password);
        this.validateTrustStoreIfAgentCertificateExists(trustStore);
        this.save(trustStore, this.getDefaultTrustStoreFile(), password);
    }

    protected void validateTrustStoreIfAgentCertificateExists(KeyStore trustStore) {
        if (this.agentCertificate == null) {
            return;
        }
        try {
            this.agentCertificate.verify(this.getConsoleCertificate(trustStore).getPublicKey());
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            InstallerUtils.error(InstallerMessages.invalidCertificate());
            System.exit(1);
        }
    }

    protected Certificate getConsoleCertificate(KeyStore truststore) throws KeyStoreException {
        if (truststore.getCertificate(CLOUD_CERTIFICATE_ALIAS) != null) {
            return truststore.getCertificate(CLOUD_CERTIFICATE_ALIAS);
        }
        if (truststore.getCertificate(CLOUD_CERTIFICATE_ALIAS_LEGACY) != null) {
            return truststore.getCertificate(CLOUD_CERTIFICATE_ALIAS_LEGACY);
        }
        if (truststore.getCertificate(PCE_CERTIFICATE_ALIAS) != null) {
            return truststore.getCertificate(PCE_CERTIFICATE_ALIAS);
        }
        throw new KeyStoreException("Could not retrieve console certificate.");
    }

    protected String getKeystoreType() {
        return this.keystoreType;
    }

    public static class Builder {
        private File confFolder;
        private InputStream agentCertificateIS;
        private InputStream caCertificateIS;
        private InputStream[] chainCertificates;
        private boolean onPrem;
        private boolean isHyperforce;
        private String builtInTruststoreFilename;
        private CryptographyStrategy cryptographyStrategy;

        public Builder(CryptographyStrategy cryptographyStrategy, File confFolder, boolean onPrem, boolean isHyperforce) {
            this.cryptographyStrategy = cryptographyStrategy;
            this.confFolder = confFolder;
            this.onPrem = onPrem;
            this.isHyperforce = isHyperforce;
        }

        public Builder addAgentCertificate(InputStream certificate) {
            this.agentCertificateIS = certificate;
            return this;
        }

        public Builder addCACertificate(InputStream certificate) {
            this.addCACertificate(certificate, null);
            return this;
        }

        public Builder addChainCertificates(InputStream[] chainCertificates) {
            this.chainCertificates = chainCertificates;
            return this;
        }

        public Builder addCACertificate(InputStream certificate, String builtInTruststoreFilename) {
            this.caCertificateIS = certificate;
            this.builtInTruststoreFilename = builtInTruststoreFilename;
            return this;
        }

        public KeyStoreStrategy build() throws Exception {
            File keystoreFile = null;
            Certificate agentCertificate = null;
            Certificate[] agentChainCertificates = null;
            if (this.agentCertificateIS != null) {
                keystoreFile = new File(this.confFolder, "mule-agent.jks");
                agentCertificate = this.buildCertificateFromInputStream(this.agentCertificateIS);
            }
            if (this.chainCertificates != null && this.chainCertificates.length > 0) {
                agentChainCertificates = new Certificate[this.chainCertificates.length];
                for (int i = 0; i < this.chainCertificates.length; ++i) {
                    agentChainCertificates[i] = this.buildCertificateFromInputStream(this.chainCertificates[i]);
                }
            }
            File defaultTrustStoreFile = new File(this.confFolder, "anypoint-truststore.jks");
            if (this.caCertificateIS == null || this.isHyperforce) {
                return new DefaultKeyStoreStrategy(keystoreFile, agentCertificate, defaultTrustStoreFile, this.builtInTruststoreFilename, this.onPrem, this.isHyperforce, agentChainCertificates, this.cryptographyStrategy.getKeystoreType().name());
            }
            Certificate caCertificate = this.buildCertificateFromInputStream(this.caCertificateIS);
            return new HybridKeyStoreStrategy(keystoreFile, agentCertificate, defaultTrustStoreFile, this.builtInTruststoreFilename, caCertificate, this.onPrem, this.cryptographyStrategy.getKeystoreType().name());
        }

        private Certificate buildCertificateFromInputStream(InputStream certificate) throws CertificateException, NoSuchProviderException {
            if (AgentSecurityProvider.DEFAULT == this.cryptographyStrategy.getProvider()) {
                return CertificateFactory.getInstance(this.cryptographyStrategy.getCertificateType().value()).generateCertificate(certificate);
            }
            return CertificateFactory.getInstance(this.cryptographyStrategy.getCertificateType().value(), this.cryptographyStrategy.getProvider().name()).generateCertificate(certificate);
        }
    }
}

