/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer.encryption;

import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.exception.SecretAlreadyEncryptedException;
import com.mulesoft.agent.exception.SecretNotFoundException;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.installer.encryption.EncryptionCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EncryptionCommandExecutor {
    private List<EncryptionCommand> commands = new ArrayList<EncryptionCommand>();
    private boolean anySecretEncrypted = false;
    private boolean anyError = false;

    private EncryptionCommandExecutor() {
    }

    public static EncryptionCommandExecutor newInstance() {
        return new EncryptionCommandExecutor();
    }

    public EncryptionCommandExecutor addCommand(EncryptionCommand command) {
        if (command == null) {
            return this;
        }
        this.commands.add(command);
        return this;
    }

    public void execute() throws IOException {
        for (EncryptionCommand command : this.commands) {
            try {
                command.execute();
                InstallerUtils.info(String.format(InstallerMessages.encryptionSecretSuccess(command.getName()), new Object[0]));
                this.anySecretEncrypted = true;
            }
            catch (SecretNotFoundException secretNotFoundException) {
            }
            catch (SecretAlreadyEncryptedException e) {
                InstallerUtils.info(String.format(InstallerMessages.encryptionValueAlreadyEncrypted(command.getName()), new Object[0]));
            }
            catch (AgentEncryptionException e) {
                this.anyError = true;
                InstallerUtils.error(String.format(InstallerMessages.encryptionSecretFailed(command.getName(), e.getMessage()), new Object[0]));
            }
        }
    }

    public boolean isAnySecretEncrypted() {
        return this.anySecretEncrypted;
    }

    public boolean isAnyError() {
        return this.anyError;
    }

    protected List<EncryptionCommand> getCommands() {
        return this.commands.stream().collect(Collectors.toList());
    }
}

