/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.configuration.ConfigurablePropertyModule;
import com.mulesoft.agent.configuration.common.AuthProxyClientProvider;
import com.mulesoft.agent.configuration.encryption.EncryptionServiceBuilder;
import com.mulesoft.agent.domain.certificates.CertificateRenewalRequest;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.installer.AgentInstaller;
import com.mulesoft.agent.installer.EnvironmentInfo;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.installer.MuleAgentYaml;
import com.mulesoft.agent.installer.keystore.KeyStoreUtils;
import com.mulesoft.agent.installer.migrator.DescriptorMigrator;
import com.mulesoft.agent.installer.request.UpgradeRequest;
import com.mulesoft.agent.installer.response.EnvironmentUrls;
import com.mulesoft.agent.installer.response.UpgradeResponse;
import com.mulesoft.agent.security.AgentSecurityManager;
import com.mulesoft.agent.security.AgentSecurityManagerBuilder;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.security.model.KeyPairWrapper;
import com.mulesoft.agent.security.model.KeystoreType;
import com.mulesoft.agent.security.providers.PropertyFipsConfigurationProvider;
import com.mulesoft.agent.services.MuleConfigurationService;
import com.mulesoft.agent.util.service.DefaultMuleConfigurationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.cli.CommandLine;
import org.asynchttpclient.Response;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.WireModule;

public class Updater
extends AgentInstaller {
    public static final PrintStream out = System.out;
    private static final String MULE_TOOLS_DIRECTORY = "tools";
    private static final String MULE_AGENT_BACKUP = "mule-agent-backup.zip";
    private static final String MULE_AGENT_MODULES_BACKUP = "mule-agent-modules-backup.zip";
    private static final String MULE_AGENT_YML = "mule-agent.yml";
    public static final String MULE_AGENT_MODULES_DIRECTORY = "lib" + File.separator + "modules";
    private AuthenticationProxyClient authProxyClient;
    private Gson gson = new Gson();
    private DescriptorMigrator descriptorMigrator;
    private MuleConfigurationService muleConfigurationService;
    private AgentSecurityManager agentSecurityManager;
    private AuthProxyClientProvider authProxyClientProvider;
    boolean isFipsEnabled;

    public Updater(File muleHome, File confDirectory, File pluginsDirectory, CommandLine commandLine) {
        super(muleHome, confDirectory, pluginsDirectory);
        Injector injector = Guice.createInjector(new WireModule(new SpaceModule(new URLClassSpace(this.getClass().getClassLoader())), new EnvironmentModule(commandLine), new ConfigurablePropertyModule(MULE_AGENT_YML, this.confFolder.getAbsolutePath())));
        this.descriptorMigrator = injector.getInstance(DescriptorMigrator.class);
        this.renameTruststoreFileIfNeeded(confDirectory);
        this.isFipsEnabled = commandLine.hasOption("fips");
        String installedAgentVersion = InstallerUtils.getInstalledAgentVersion(muleHome);
        InstallerUtils.info("Update for the installedAgentVersion=" + installedAgentVersion);
        String securityConfigKeystoreType = Security.getProperty("keystore.type");
        if (this.isFipsEnabled && securityConfigKeystoreType.equals(KeystoreType.FIPS.toString())) {
            this.convertPKCS12ToFIPSBCJKS(confDirectory);
        }
        this.agentSecurityManager = AgentSecurityManagerBuilder.newInstance().enableFips(this.isFipsEnabled).build();
        this.authProxyClientProvider = injector.getInstance(AuthProxyClientProvider.class);
        this.muleConfigurationService = new DefaultMuleConfigurationService();
    }

    @Override
    public void install() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchAlgorithmException, AgentEncryptionException {
        if (!this.isFipsEnabled && this.muleConfigurationService.isPropertySet(this.confFolder, "mule.security.model", PropertyFipsConfigurationProvider.FIPS_SECURITY_MODEL)) {
            throw new RuntimeException("Upgrade will not proceed since fips parameter is missing and fips is found to be enabled in wrapper.conf.\nPlease re-run the upgrade with the command - \"amc_setup -U --fips\".");
        }
        MuleAgentYaml descriptorYaml = MuleAgentYaml.newInstance(this.confFolder, MULE_AGENT_YML);
        try {
            this.updateTrustStore(descriptorYaml);
        }
        catch (Exception e) {
            InstallerUtils.error(String.format("Error trying to update the truststore file %s", e.getMessage()));
        }
        this.agentSecurityManager.initialize();
        InstallerUtils.info(String.format("Fips enabled: %s", this.agentSecurityManager.isFipsEnabled()));
        String agentVersion = InstallerUtils.getInstalledAgentVersion(this.muleHome);
        this.authProxyClient = this.authProxyClientProvider.getClient(this.confFolder.getPath(), agentVersion);
        if (!InstallerUtils.isAgentInstalled(this.muleHome)) {
            InstallerUtils.error(InstallerMessages.pluginNotInstalledErrorMessage());
            System.exit(-1);
        }
        String currentVersion = InstallerUtils.getInstalledAgentVersion(this.muleHome);
        if (this.authProxyClient != null) {
            try {
                this.autoRenewCertificate(descriptorYaml);
            }
            catch (Exception e) {
                InstallerUtils.error(String.format("Error trying to renew the certificate: %s", e));
                throw new RuntimeException("Upgrade will not proceed due to failure of certificate renewal", e);
            }
            UpgradeResponse upgradeResponse = this.sendHybridUpgradeRequest(currentVersion);
            if (upgradeResponse != null) {
                this.upgradeWithARM(upgradeResponse);
                this.updateEnvironmentURLs(descriptorYaml, upgradeResponse.getUrls());
                this.disableHybridMonitoring(descriptorYaml);
            }
        } else if (descriptorYaml.isOnPremEnvironment() || !descriptorYaml.isWebsocketTransportEnabled()) {
            InstallerUtils.info("ClientId and ClientSecret not configured/updated. Offline installation.");
        } else {
            InstallerUtils.error("Websocket transport has been enabled but mule agent configuration is invalid, ensure both the keystore/truststore and authenticationProxy URL for ARM connection are properly configured in mule-agent.yml and then retry the upgrade");
            throw new RuntimeException("Websocket transport has been enabled but mule agent configuration is invalid, ensure both the keystore/truststore and authenticationProxy URL for ARM connection are properly configured in mule-agent.yml and then retry the upgrade");
        }
        File muleAgentDirectory = new File(this.pluginsFolder, "mule-agent-plugin");
        File muleAgentModulesDirectory = new File(muleAgentDirectory, MULE_AGENT_MODULES_DIRECTORY);
        File toolsDirectory = new File(this.muleHome, MULE_TOOLS_DIRECTORY);
        if (!toolsDirectory.exists()) {
            toolsDirectory.mkdir();
        }
        InstallerUtils.zip(muleAgentDirectory, new File(toolsDirectory, MULE_AGENT_BACKUP));
        InstallerUtils.zip(muleAgentModulesDirectory, new File(toolsDirectory, MULE_AGENT_MODULES_BACKUP));
        super.installAgentPlugin();
        InstallerUtils.unzip(new FileInputStream(new File(toolsDirectory, MULE_AGENT_MODULES_BACKUP)), new File(muleAgentDirectory, MULE_AGENT_MODULES_DIRECTORY));
        this.descriptorMigrator.migrate(new File(this.confFolder, MULE_AGENT_YML), currentVersion);
        InstallerUtils.info(InstallerMessages.updateEndOfScriptMessage());
    }

    private void disableHybridMonitoring(MuleAgentYaml descriptorYaml) {
        if (descriptorYaml.isOnPrem()) {
            try {
                descriptorYaml.disableHybridMonitoring();
            }
            catch (IOException e) {
                InstallerUtils.info(String.format("Error disabling the Hybrid Monitoring %s", e.getMessage()));
            }
        }
    }

    private void updateTrustStore(MuleAgentYaml descriptorYaml) throws Exception {
        if (!descriptorYaml.isOnPrem()) {
            return;
        }
        String decryptedKeystorePassword = EncryptionServiceBuilder.newInstance().build().decrypt(descriptorYaml.getKeyStorePassword());
        String pemContent = this.getOnPremRootCertificates();
        KeyStoreUtils.importOnPremTrustStores(this.confFolder.getPath(), pemContent, decryptedKeystorePassword, FipsUtils.getKeystoreType());
    }

    private String getOnPremRootCertificates() throws IOException {
        try {
            return Resources.toString(Objects.requireNonNull(this.getClass().getClassLoader().getResource("onPrem-root.pem")), Charsets.UTF_8);
        }
        catch (IOException e) {
            InstallerUtils.error(String.format("Error reading the PEM file: %s", "onPrem-root.pem"));
            throw e;
        }
    }

    public void autoRenewCertificate(MuleAgentYaml descriptorYaml) throws Exception {
        if (descriptorYaml.isOnPremEnvironment()) {
            return;
        }
        String decryptedKeystorePassword = EncryptionServiceBuilder.newInstance().build().decrypt(descriptorYaml.getKeyStorePassword());
        Certificate certificate = KeyStoreUtils.loadDefaultCertificate(this.confFolder.getPath(), decryptedKeystorePassword, FipsUtils.getKeystoreType(), descriptorYaml.getKeyStoreAlias());
        KeyPairWrapper keyPairWrapper = this.agentSecurityManager.generateKeyPair();
        PKCS10CertificationRequest signRequest = this.agentSecurityManager.generateAgentCertificateSigningRequest(keyPairWrapper);
        CertificateRenewalRequest certificateRenewalRequest = new CertificateRenewalRequest(KeyStoreUtils.toPem(certificate), KeyStoreUtils.toPem(signRequest));
        Response response = this.authProxyClient.put("/mule/servers", certificateRenewalRequest);
        KeyStoreUtils.backupJKS(this.confFolder);
        InputStream certificateAsInputStream = this.agentSecurityManager.transformCSRtoCertificate(response.getResponseBodyAsStream());
        KeyStoreUtils.generateJKS(this.confFolder, certificateAsInputStream, keyPairWrapper, decryptedKeystorePassword.toCharArray(), this.agentSecurityManager.getCryptographyStrategy().getKeystoreType().name(), descriptorYaml.getKeyStoreAlias());
        InstallerUtils.info("Certificate auto renewed successfully");
    }

    private void overwriteIfPresent(Map<String, String> wrapperProperties, String key, String newValue) {
        if (newValue != null && !newValue.isEmpty()) {
            wrapperProperties.put(key, newValue);
        }
    }

    private void upgradeWithARM(UpgradeResponse upgradeResponse) {
        HashMap<String, String> wrapperProperties = new HashMap<String, String>();
        this.overwriteIfPresent(wrapperProperties, "anypoint.platform.client_id", upgradeResponse.getClientId());
        this.overwriteIfPresent(wrapperProperties, "anypoint.platform.client_secret", upgradeResponse.getClientSecret());
        if (upgradeResponse.getUrls() != null) {
            this.overwriteIfPresent(wrapperProperties, "anypoint.platform.base_uri", upgradeResponse.getUrls().getAnypointBaseUrl());
        }
        try {
            this.muleConfigurationService.addWrapperJavaAdditionalProperties(this.confFolder, wrapperProperties);
            InstallerUtils.info("Updated clientId and clientSecret successfully");
        }
        catch (IOException e) {
            InstallerUtils.error("ClientId and ClientSecret not updated. Reason: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void addPropertyIfNewValuePresent(Map<String, String> wrapperProperties, String key, String newValue) {
        if (newValue != null && !newValue.isEmpty()) {
            wrapperProperties.put(key, newValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkKeystoreFileIsBCFKS(File file, char[] storePass) {
        try (FileInputStream keystoreInput = new FileInputStream(file);){
            KeyStore keystore = KeyStore.getInstance("FIPS", "BCFIPS");
            keystore.load(keystoreInput, storePass);
            String keystoreType = keystore.getType();
            InstallerUtils.debug("Keystore type: " + keystoreType);
            if ("FIPS".equalsIgnoreCase(keystoreType)) {
                InstallerUtils.debug("The keystore is of FIPS/BCFKS type.");
                boolean bl2 = true;
                return bl2;
            }
            InstallerUtils.info("The keystore type is NOT FIPS/BCFKS type: " + keystoreType);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void convertPKCS12ToFIPSBCJKS(File confFolder) {
        try {
            MuleAgentYaml descriptorYaml = MuleAgentYaml.newInstance(confFolder, MULE_AGENT_YML);
            char[] storePassword = descriptorYaml.getKeyStorePassword();
            char[] storeAliasPassword = descriptorYaml.getKeyStoreAliasPassword();
            if (Security.getProvider("BCFIPS") == null) {
                Security.addProvider((Provider)Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
            String formattedDate = LocalDateTime.now().format(formatter);
            try (Stream<Path> paths = Files.walk(confFolder.toPath(), new FileVisitOption[0]);){
                paths.filter(p -> p.toString().endsWith(".jks")).forEach(path -> {
                    File file = path.toFile();
                    if (this.checkKeystoreFileIsBCFKS(file, storePassword)) {
                        InstallerUtils.debug("The file " + file.getName() + " is already FIPS/BCFKS");
                        return;
                    }
                    try {
                        Path backupFile = this.backupFile(file, formattedDate);
                        this.convertToFIPSBCFKSImpl(backupFile.toFile(), file, storePassword, storeAliasPassword);
                        InstallerUtils.info("Converted file " + file.getName() + " from PKCS12 to FIPS/BCJKS");
                    }
                    catch (Exception e) {
                        InstallerUtils.error("Error converting " + file.getName() + " to FIPS/BCFKS: " + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            InstallerUtils.error("Failed to convert PKCS12 to FIPS/BCFKS type, error: " + e.getMessage());
            System.exit(1);
        }
    }

    private Path backupFile(File file, String timestamp) throws IOException {
        Path backupPath = Paths.get(file.getParent(), file.getName() + ".pkcs12_backup_" + timestamp);
        Files.copy(file.toPath(), backupPath, StandardCopyOption.REPLACE_EXISTING);
        return backupPath;
    }

    private void convertToFIPSBCFKSImpl(File pkcs12File, File outputFile, char[] storePassword, char[] aliasPassword) throws Exception {
        KeyStore pkcs12Keystore = KeyStore.getInstance("PKCS12", "BCFIPS");
        try (FileInputStream fis = new FileInputStream(pkcs12File);){
            pkcs12Keystore.load(fis, storePassword);
        }
        KeyStore fipsbcfksKeystore = KeyStore.getInstance("FIPS", "BCFIPS");
        fipsbcfksKeystore.load(null, null);
        Enumeration<String> aliases = pkcs12Keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (pkcs12Keystore.isKeyEntry(alias)) {
                KeyStore.Entry entry = pkcs12Keystore.getEntry(alias, new KeyStore.PasswordProtection(aliasPassword));
                fipsbcfksKeystore.setEntry(alias, entry, new KeyStore.PasswordProtection(aliasPassword));
                continue;
            }
            if (!pkcs12Keystore.isCertificateEntry(alias)) continue;
            fipsbcfksKeystore.setCertificateEntry(alias, pkcs12Keystore.getCertificate(alias));
        }
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            fipsbcfksKeystore.store(fos, storePassword);
        }
    }

    private boolean renameTruststoreFileIfNeeded(File confFolder) {
        File oldTruststoreFile = new File(confFolder, "truststore.jks");
        File truststoreFile = new File(confFolder, "anypoint-truststore.jks");
        if (truststoreFile.exists()) {
            InstallerUtils.info(InstallerMessages.truststoreExistMessage(truststoreFile.getName()));
            return false;
        }
        if (!oldTruststoreFile.exists()) {
            InstallerUtils.info(InstallerMessages.truststoreNotFoundMessage());
            return false;
        }
        try {
            InstallerUtils.info(InstallerMessages.truststoreFileMustBeRenamedMessage(oldTruststoreFile.getName(), truststoreFile.getName()));
            if (oldTruststoreFile.renameTo(truststoreFile)) {
                InstallerUtils.info(InstallerMessages.truststoreRenameSuccessMessage());
            }
        }
        catch (Exception e) {
            InstallerUtils.error("File truststore.jks not renamed. Reason: " + e.getMessage());
            System.exit(1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeResponse sendHybridUpgradeRequest(String currentVersion) {
        UpgradeResponse upgradeResponse = null;
        try {
            UpgradeRequest upgradeRequest = new UpgradeRequest(currentVersion, InstallerUtils.getAgentVersionFromManifest(currentVersion));
            Response authProxyReply = this.authProxyClient.post("/mule/servers", upgradeRequest);
            if (authProxyReply.getStatusCode() == Response.Status.OK.getStatusCode()) {
                upgradeResponse = this.gson.fromJson(authProxyReply.getResponseBody(), UpgradeResponse.class);
            } else {
                InstallerUtils.error("ClientId and ClientSecret not updated. Reason: Authentication Proxy status: " + authProxyReply.getStatusCode());
                System.out.println(authProxyReply.getResponseBody());
            }
        }
        catch (Exception e) {
            InstallerUtils.error("ClientId and ClientSecret not updated. Reason: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.authProxyClient.close();
        }
        return upgradeResponse;
    }

    private void updateEnvironmentURLs(MuleAgentYaml descriptorYaml, EnvironmentUrls urls2) {
        if (urls2 == null) {
            return;
        }
        File descriptorFile = new File(this.confFolder, MULE_AGENT_YML);
        boolean isConfigFileChanged = false;
        try {
            String ingestionServiceEndpoint;
            String proxyEndpoint;
            String consoleUri = descriptorYaml.getConsoleUri();
            if (!consoleUri.equals(urls2.getMcmWebsocketUrl())) {
                descriptorYaml.setConsoleUri(urls2.getMcmWebsocketUrl());
                isConfigFileChanged = true;
            }
            if (!(proxyEndpoint = descriptorYaml.getEndpoint()).equals(urls2.getAuthProxyUrl())) {
                isConfigFileChanged = true;
                descriptorYaml.setEndpoint(urls2.getAuthProxyUrl());
            }
            if ((ingestionServiceEndpoint = descriptorYaml.getMetricIngestionEndpoint()) == null || !ingestionServiceEndpoint.equals(urls2.getIngestionServiceUrl())) {
                isConfigFileChanged = true;
                String ingestionUrl = urls2.getIngestionServiceUrl() != null && !urls2.getIngestionServiceUrl().isEmpty() ? urls2.getIngestionServiceUrl() : null;
                descriptorYaml.setIngestionServiceEndpoint(ingestionUrl);
            }
            descriptorYaml.dump();
            if (isConfigFileChanged) {
                InstallerUtils.info(InstallerMessages.agentDescriptorDNSChangedMessage());
            }
        }
        catch (IOException e) {
            System.out.println("Error while processing descriptor file for update");
            e.printStackTrace();
        }
    }

    class EnvironmentModule
    extends AbstractModule {
        EnvironmentInfo environmentInfo;

        EnvironmentModule(CommandLine commandLine) {
            this.environmentInfo = new EnvironmentInfo.EnvironmentInfoBuilder(commandLine).build();
        }

        @Override
        protected void configure() {
            this.bind(EnvironmentInfo.class).toInstance(this.environmentInfo);
        }
    }
}

