/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.installer.AgentInstaller;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.installer.utils.InstallerCertificateUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.io.FileUtils;

public class SecureInstaller
extends AgentInstaller {
    public static final PrintStream out = System.out;

    public SecureInstaller(File muleHome, File confFolder, File pluginsFolder) {
        super(muleHome, confFolder, pluginsFolder);
    }

    @Override
    public void install() throws IOException {
        super.installAgentPlugin();
        out.println(InstallerMessages.secureInstallerDescription());
        StringBuffer buffer = new StringBuffer();
        File keystoreLocation = InstallerUtils.readFileFromConsole("Keystore location", InstallerMessages.keystoreDescription());
        String keystorePassword = InstallerUtils.readPassword("Keystore Password", InstallerMessages.keystorePassword());
        File truststoreLocation = InstallerUtils.readFileFromConsole("Truststore location", InstallerMessages.truststoreDescription());
        String keystoreAlias = InstallerUtils.readFromConsole("Keystore Alias", InstallerMessages.keystoreAlias());
        String keystoreAliasPassword = InstallerUtils.readPassword("Keystore Alias Password", InstallerMessages.keystoreAliasPassword());
        if (!InstallerCertificateUtils.validateKeystoreAlias(keystoreLocation, keystorePassword, keystoreAlias, keystoreAliasPassword)) {
            System.exit(0);
        }
        FileUtils.copyFile(keystoreLocation, new File(this.confFolder, keystoreLocation.getName()));
        FileUtils.copyFile(truststoreLocation, new File(this.confFolder, "anypoint-truststore.jks"));
        this.addDescriptorLine(buffer, "keyStoreFile", keystoreLocation.getName());
        this.addDescriptorLine(buffer, "keystorePassword", keystorePassword);
        this.addDescriptorLine(buffer, "keyStoreAlias", keystoreAlias);
        this.addDescriptorLine(buffer, "keyStoreAliasPassword", keystoreAliasPassword);
        FileUtils.writeStringToFile(new File(this.confFolder, "mule-agent.yml"), String.format("---%ntransports:%n  websocket.transport:%n    enabled: false%n%n  rest.agent.transport:%n    restSecurity:%n%s    port: 9999%n", String.format(buffer.toString(), new Object[0])));
        InstallerUtils.info(InstallerMessages.secureSuccessful());
    }

    private void addDescriptorLine(StringBuffer buffer, String keyStoreAliasPassword1, String keyStoreAliasPassword) {
        if (!keyStoreAliasPassword.isEmpty()) {
            buffer.append(String.format("      %s: %s%n", keyStoreAliasPassword1, keyStoreAliasPassword));
        }
    }
}

