/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.installer.AgentInstaller;
import com.mulesoft.agent.installer.HybridInstaller;
import com.mulesoft.agent.installer.InsecureInstaller;
import com.mulesoft.agent.installer.SecureInstaller;
import com.mulesoft.agent.installer.Updater;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.cli.CommandLine;

public enum ScriptOption {
    I(new InstallerFactory(){

        @Override
        public AgentInstaller create(File muleHomeDirectory, File confDirectory, File pluginsDirectory, CommandLine commandLine) {
            return InsecureInstaller.newFor(muleHomeDirectory, confDirectory, pluginsDirectory);
        }
    }),
    H(new InstallerFactory(){

        @Override
        public AgentInstaller create(File muleHomeDirectory, File confDirectory, File pluginsDirectory, CommandLine commandLine) {
            return new HybridInstaller(muleHomeDirectory, confDirectory, pluginsDirectory, commandLine);
        }
    }),
    S(new InstallerFactory(){

        @Override
        public AgentInstaller create(File muleHomeDirectory, File confDirectory, File pluginsDirectory, CommandLine commandLine) {
            return new SecureInstaller(muleHomeDirectory, confDirectory, pluginsDirectory);
        }
    }),
    U(new InstallerFactory(){

        @Override
        public AgentInstaller create(File muleHomeDirectory, File confDirectory, File pluginsDirectory, CommandLine commandLine) {
            return new Updater(muleHomeDirectory, confDirectory, pluginsDirectory, commandLine);
        }
    });

    private InstallerFactory factory;

    private ScriptOption(InstallerFactory factory2) {
        this.factory = factory2;
    }

    void runOn(File muleHomeDirectory, File confDirectory, File pluginsDirectory, CommandLine commandLine) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchAlgorithmException, AgentEncryptionException {
        this.factory.create(muleHomeDirectory, confDirectory, pluginsDirectory, commandLine).install();
    }

    static ScriptOption thatMatchesWith(String mode) {
        return ScriptOption.valueOf(mode);
    }

    public static interface InstallerFactory {
        public AgentInstaller create(File var1, File var2, File var3, CommandLine var4);
    }
}

