/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.exception.CredentialEncryptionNotSupportedException;
import com.mulesoft.agent.installer.RuntimeEncrypter;
import com.mulesoft.agent.services.RuntimeVersionService;

public class RuntimeEncrypterBuilder {
    private static final String USER_AGENT = "Mozilla/5.0";
    private RuntimeVersionService runtimeVersionService;
    private String muleVersion;
    private String encryptionKey;

    private RuntimeEncrypterBuilder() {
    }

    public static RuntimeEncrypterBuilder newInstance() {
        return new RuntimeEncrypterBuilder();
    }

    public RuntimeEncrypterBuilder addRuntimeVersionService(RuntimeVersionService runtimeVersionService) {
        this.runtimeVersionService = runtimeVersionService;
        return this;
    }

    public RuntimeEncrypterBuilder addMuleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
        return this;
    }

    public RuntimeEncrypterBuilder addEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public RuntimeEncrypter build() throws CredentialEncryptionNotSupportedException {
        if (this.encryptionKey == null) {
            return null;
        }
        if (!this.runtimeVersionService.supportsEncryptedCredentials(this.muleVersion)) {
            throw new CredentialEncryptionNotSupportedException(String.format("Current runtime version %s does not support encrypted credentials. Skipping credentials encryption.", this.muleVersion));
        }
        RuntimeEncrypter runtimeEncrypter = new RuntimeEncrypter(this.encryptionKey);
        this.validateRuntimeEncrypter(runtimeEncrypter);
        return runtimeEncrypter;
    }

    private void validateRuntimeEncrypter(RuntimeEncrypter runtimeEncrypter) {
        try {
            if (runtimeEncrypter != null) {
                runtimeEncrypter.encrypt(USER_AGENT);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error trying to encrypt using the given encryption configuration: %s", e.getCause().getMessage()));
        }
    }

    protected RuntimeVersionService getRuntimeVersionService() {
        return this.runtimeVersionService;
    }

    protected String getMuleVersion() {
        return this.muleVersion;
    }

    protected String getEncryptionKey() {
        return this.encryptionKey;
    }
}

