/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import java.util.Base64;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.SymmetricKeyFactory;

public class RuntimeEncrypter {
    private static final String PREFIX = "![";
    private static final String SUFFIX = "]";
    private Encrypter encrypter;

    public RuntimeEncrypter(String encryptionKey) {
        Objects.requireNonNull(encryptionKey, "Encryption key can not be null");
        SymmetricKeyFactory keyFactory = () -> new SecretKeySpec(encryptionKey.getBytes(), "AES");
        this.encrypter = new JCEEncrypter("AES/CBC/PKCS5Padding", keyFactory);
    }

    public String encrypt(String valueToEncrypt) {
        try {
            Objects.requireNonNull(valueToEncrypt, "Value to encrypt can not be null");
            byte[] contentBytes = valueToEncrypt.getBytes();
            byte[] encryptedValue = this.encrypter.encrypt(contentBytes);
            return String.format("%s%s%s", PREFIX, new String(Base64.getEncoder().encode(encryptedValue)), SUFFIX);
        }
        catch (MuleEncryptionException e) {
            throw new RuntimeException("Error trying to encrypt " + valueToEncrypt, e);
        }
    }
}

