/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;

public class ProxyKerberosInfo {
    private final String krb5ConfigurationPath;
    private final String jaasConfigurationPath;
    public static final ProxyKerberosInfo DEFAULT = new ProxyKerberosInfo(null, null);

    private ProxyKerberosInfo(String krb5ConfigurationPath, String jaasConfigurationPath) {
        this.krb5ConfigurationPath = krb5ConfigurationPath;
        this.jaasConfigurationPath = jaasConfigurationPath;
    }

    public String getKrb5ConfigurationPath() {
        return this.krb5ConfigurationPath;
    }

    public String getJaasConfigurationPath() {
        return this.jaasConfigurationPath;
    }

    public Boolean isValid() {
        Boolean isValid = StringUtils.isNotEmpty(this.krb5ConfigurationPath) && StringUtils.isNotEmpty(this.jaasConfigurationPath);
        return isValid;
    }

    public static class ProxyKerberosInfoBuilder {
        private final String krb5ConfigurationPath;
        private final String jaasConfigurationPath;

        public ProxyKerberosInfoBuilder(CommandLine commandLine) {
            String[] proxyOptions = commandLine.getOptionValues("use-kerberos-proxy");
            this.krb5ConfigurationPath = proxyOptions != null ? proxyOptions[0] : null;
            this.jaasConfigurationPath = proxyOptions != null ? proxyOptions[1] : null;
        }

        public ProxyKerberosInfo build() {
            return new ProxyKerberosInfo(this.krb5ConfigurationPath, this.jaasConfigurationPath);
        }
    }
}

