/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;

public class ProxyInfo {
    private final String host;
    private final String port;
    private final String user;
    private final String password;
    private final boolean trafficInspectionEnabled;
    public static final ProxyInfo DEFAULT = new ProxyInfo(null, null, null, "", false);

    private ProxyInfo(String host, String port, String user, String password, boolean trafficInspectionEnabled) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.trafficInspectionEnabled = trafficInspectionEnabled;
    }

    public String getPassword() {
        return this.password != null ? this.password : "";
    }

    public String getUser() {
        return this.user;
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isTrafficInspectionEnabled() {
        return this.trafficInspectionEnabled;
    }

    public boolean isAnonymous() {
        return StringUtils.isBlank(this.getUser());
    }

    public static class ProxyInfoBuilder {
        private String host;
        private String port;
        private String user;
        private String password;
        private boolean trafficInspectionEnabled;

        public ProxyInfoBuilder(CommandLine commandLine) {
            String[] proxyOptions = commandLine.getOptionValues("P");
            this.host = proxyOptions != null ? proxyOptions[0] : null;
            this.port = proxyOptions != null && proxyOptions.length > 1 ? proxyOptions[1] : null;
            this.user = proxyOptions != null && proxyOptions.length > 2 ? proxyOptions[2] : null;
            this.password = proxyOptions != null && proxyOptions.length > 3 ? proxyOptions[3] : null;
            this.trafficInspectionEnabled = commandLine.hasOption("enable-traffic-inspection");
        }

        public ProxyInfo build() {
            if (StringUtils.isNotEmpty(this.host) && StringUtils.isNotEmpty(this.port)) {
                return new ProxyInfo(this.host, this.port, this.user, this.password, this.trafficInspectionEnabled);
            }
            return null;
        }
    }
}

