/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

public final class PlatformUrl {
    private final PlatformUrlSource source;
    private final String url;

    private PlatformUrl() {
        this.url = null;
        this.source = null;
    }

    private PlatformUrl(String url, PlatformUrlSource source2) {
        this.url = url;
        this.source = source2;
    }

    public PlatformUrlSource getSource() {
        return this.source;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isEmpty() {
        return this.url == null;
    }

    public static PlatformUrl fromCommandLine(String url) {
        return new PlatformUrl(url, PlatformUrlSource.COMMAND_LINE);
    }

    public static PlatformUrl fromPropertyFile(String url) {
        return new PlatformUrl(url, PlatformUrlSource.BUNDLED);
    }

    public static PlatformUrl fromService(String url) {
        return new PlatformUrl(url, PlatformUrlSource.SERVICE);
    }

    public static PlatformUrl empty() {
        return new PlatformUrl();
    }

    public String toString() {
        return "PlatformUrl{source=" + (Object)((Object)this.source) + ", url='" + this.url + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformUrl that = (PlatformUrl)o;
        if (this.source != that.source) {
            return false;
        }
        return this.url != null ? this.url.equals(that.url) : that.url == null;
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    static enum PlatformUrlSource {
        COMMAND_LINE,
        BUNDLED,
        SERVICE;

    }
}

