/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.configuration.descriptor.YamlBuilder;
import com.mulesoft.agent.configuration.descriptor.YamlWrapper;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.yaml.snakeyaml.Yaml;

public class MuleAgentYaml {
    public static final String TRANSPORTS_KEY = "transports";
    public static final String WEBSOCKET_TRANSPORT_KEY = "websocket.transport";
    public static final String CONSOLE_URI = "consoleUri";
    public static final String GLOBAL_CONFIGURATION = "globalConfiguration";
    public static final String SECURITY = "security";
    public static final String AUTHENTICATION_PROXY = "authenticationProxy";
    public static final String METRIC_INGESTION = "metricIngestion";
    public static final String AUTHENTICATION_PROXY_ENDPOINT = "endpoint";
    public static final String METRIC_INGESTION_ENDPOINT = "endpoint";
    public static final String KEYSTORE_PASSWORD = "keyStorePassword";
    public static final String KEYSTORE_ALIAS_PASSWORD = "keyStoreAliasPassword";
    public static final String KEYSTORE_ALIAS = "keyStoreAlias";
    public static final String ENVIRONMENT_KEY = "environment";
    public static final String INTERNAL_HANDLERS = "internalHandlers";
    public static final String TRACKING_HANDLER_ANALYTICS = "mule.agent.tracking.handler.analytics";
    public static final String INGEST_TARGET_METRICS = "mule.agent.ingest.target.metrics.internal.handler";
    public static final String TRACKING_INGEST_APPLICATION_METRICS = "mule.agent.ingest.application.metrics.internal.handler";
    public static final String ENABLED_PROPERTY_VALUE = "enabled";
    private Map configuration;
    private Yaml yaml;
    private File descriptorFile;

    private MuleAgentYaml(File descriptorFile) throws IOException {
        this.descriptorFile = descriptorFile;
        this.yaml = YamlBuilder.newInstance().build();
        try (FileReader reader = new FileReader(descriptorFile);){
            this.configuration = (Map)this.yaml.load(reader);
        }
    }

    public static MuleAgentYaml newInstance(File descriptorFile) throws IOException {
        return new MuleAgentYaml(descriptorFile);
    }

    public static MuleAgentYaml newInstance(File folder, String filename) throws IOException {
        return new MuleAgentYaml(new File(folder, filename));
    }

    private Map getTransports() {
        return (Map)this.configuration.get(TRANSPORTS_KEY);
    }

    private Map getWebSocketTransport() {
        return (Map)this.getTransports().get(WEBSOCKET_TRANSPORT_KEY);
    }

    public String getConsoleUri() {
        return (String)this.getWebSocketTransport().get(CONSOLE_URI);
    }

    public boolean isWebsocketTransportEnabled() {
        Map websocketTransport = this.getWebSocketTransport();
        return websocketTransport != null && !websocketTransport.isEmpty() && websocketTransport.containsKey(ENABLED_PROPERTY_VALUE) && websocketTransport.get(ENABLED_PROPERTY_VALUE) instanceof Boolean && (Boolean)websocketTransport.get(ENABLED_PROPERTY_VALUE) != false;
    }

    public void setConsoleUri(String value) {
        this.getWebSocketTransport().put(CONSOLE_URI, value);
    }

    private Map getGlobalConfiguration() {
        return (Map)this.configuration.get(GLOBAL_CONFIGURATION);
    }

    private Map getAuthenticationProxy() {
        return (Map)this.getGlobalConfiguration().get(AUTHENTICATION_PROXY);
    }

    private Map getMetricIngestion() {
        if (!this.getGlobalConfiguration().containsKey(METRIC_INGESTION)) {
            this.getGlobalConfiguration().put(METRIC_INGESTION, new HashMap());
        }
        return (Map)this.getGlobalConfiguration().get(METRIC_INGESTION);
    }

    public String getEndpoint() {
        return (String)this.getAuthenticationProxy().get("endpoint");
    }

    public void setEndpoint(String value) {
        this.getAuthenticationProxy().put("endpoint", value);
    }

    public String getMetricIngestionEndpoint() {
        if (!this.getMetricIngestion().containsKey("endpoint")) {
            this.getMetricIngestion().put("endpoint", null);
        }
        return (String)this.getMetricIngestion().get("endpoint");
    }

    public void setIngestionServiceEndpoint(String value) {
        this.getMetricIngestion().put("endpoint", value);
    }

    public void disableHybridMonitoring() throws IOException {
        String[] keysToUpdate = new String[]{TRACKING_HANDLER_ANALYTICS, INGEST_TARGET_METRICS, TRACKING_INGEST_APPLICATION_METRICS};
        HashMap<String, HashMap<String, Boolean>> internalHandlers = (HashMap<String, HashMap<String, Boolean>>)this.configuration.get(INTERNAL_HANDLERS);
        if (internalHandlers == null) {
            internalHandlers = new HashMap<String, HashMap<String, Boolean>>();
            this.configuration.put(INTERNAL_HANDLERS, internalHandlers);
        }
        for (String key : keysToUpdate) {
            HashMap<String, Boolean> handler = (HashMap<String, Boolean>)internalHandlers.get(key);
            if (handler == null) {
                handler = new HashMap<String, Boolean>();
                handler.put(ENABLED_PROPERTY_VALUE, false);
                internalHandlers.put(key, handler);
                continue;
            }
            handler.put(ENABLED_PROPERTY_VALUE, false);
        }
        this.dump();
    }

    private Map getSecurity() {
        if (this.getGlobalConfiguration() == null) {
            return null;
        }
        return (Map)this.getGlobalConfiguration().get(SECURITY);
    }

    public char[] getKeyStorePassword() {
        Optional<String> password = Optional.ofNullable((String)this.getSecurity().get(KEYSTORE_PASSWORD));
        if (password.isPresent()) {
            return password.get().toCharArray();
        }
        return null;
    }

    public char[] getKeyStoreAliasPassword() {
        if (this.getSecurity() == null) {
            return null;
        }
        Optional<String> password = Optional.ofNullable((String)this.getSecurity().get(KEYSTORE_ALIAS_PASSWORD));
        if (password.isPresent()) {
            return password.get().toCharArray();
        }
        return null;
    }

    public String getKeyStoreAlias() {
        Optional<String> alias = Optional.ofNullable((String)Objects.requireNonNull(this.getSecurity()).get(KEYSTORE_ALIAS));
        if (alias.isPresent()) {
            return alias.get();
        }
        return null;
    }

    public String getEnvironment() {
        return (String)this.configuration.get(ENVIRONMENT_KEY);
    }

    public boolean isOnPrem() {
        return this.getEnvironment() != null;
    }

    public boolean isOnPremEnvironment() {
        return RuntimeEnvironment.ON_PREM.getValue().equals(this.getEnvironment());
    }

    public void dump() throws IOException {
        YamlWrapper.newInstance(this.yaml).dumpSafe(this.configuration, this.descriptorFile.toPath());
    }

    public void dumpUpdate(Map updatedConfiguration) throws IOException {
        YamlWrapper.newInstance(this.yaml).dumpSafe(updatedConfiguration, this.descriptorFile.toPath());
    }

    public Map getRaw() {
        return this.configuration;
    }
}

