/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.google.gson.Gson;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.commands.CommandLineOptions;
import com.mulesoft.agent.util.InstallerLoggingUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public final class InstallerUtils {
    private static String AGENT_VERSION_PREFIX = "mule-agent-api-";
    private static Gson GSON = new Gson();

    public static boolean isAgentInstalled(File muleHome) {
        File dir = new File(muleHome, "server-plugins" + File.separator + "mule-agent-plugin");
        return dir.exists();
    }

    public static String getInstalledAgentVersion(File muleHome) {
        File dir = new File(muleHome, "server-plugins" + File.separator + "mule-agent-plugin" + File.separator + "lib");
        WildcardFileFilter fileFilter = new WildcardFileFilter(AGENT_VERSION_PREFIX + "*.jar");
        File[] files = dir.listFiles(fileFilter);
        return files[0].getName().substring(AGENT_VERSION_PREFIX.length(), files[0].getName().lastIndexOf(46));
    }

    public static void unzip(InputStream archive, File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + directory);
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        try (ZipInputStream zip2 = new ZipInputStream(archive);){
            ZipEntry entry;
            byte[] buffer = new byte[2048];
            while ((entry = zip2.getNextEntry()) != null) {
                String s2 = String.format("\tCreating: %s len %d added %TD", entry.getName(), entry.getSize(), new Date(entry.getTime()));
                System.out.println(s2);
                String outpath = directory.getPath() + File.separator + entry.getName();
                if (entry.isDirectory()) {
                    new File(outpath).mkdir();
                    continue;
                }
                FileOutputStream output = new FileOutputStream(outpath);
                Throwable throwable = null;
                try {
                    int len = 0;
                    while ((len = zip2.read(buffer)) > 0) {
                        output.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
        }
    }

    public static void zip(File inputFolder, File outputFile) throws IOException {
        byte[] buffer = new byte[2048];
        FileOutputStream fos = new FileOutputStream(outputFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        List<String> fileList = InstallerUtils.generateFileList(inputFolder, inputFolder, new LinkedList<String>());
        for (String file : fileList) {
            int len;
            ZipEntry ze = new ZipEntry(file);
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(inputFolder + File.separator + file);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
        }
        zos.closeEntry();
        zos.close();
    }

    public static File getMandatoryFolder(File muleHomeDirectory, String errorMessage) {
        if (!muleHomeDirectory.exists()) {
            InstallerUtils.error(errorMessage);
            System.exit(0);
        }
        return muleHomeDirectory;
    }

    public static String readFromConsole(String message, String description) {
        System.out.print(InstallerUtils.input(message));
        try {
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String s2 = bufferRead.readLine();
            if ("?".equals(s2) && description != null) {
                System.out.println();
                InstallerUtils.help(description);
                return InstallerUtils.readFromConsole(message, description);
            }
            if ("Q".equalsIgnoreCase(s2)) {
                System.exit(0);
            }
            return s2;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String readPassword(String message, String description) {
        System.out.print(InstallerUtils.input(message));
        String s2 = new String(System.console().readPassword());
        if ("?".equals(s2) && description != null) {
            InstallerUtils.help(description);
            return InstallerUtils.readPassword(message, description);
        }
        if ("Q".equalsIgnoreCase(s2)) {
            System.exit(0);
        }
        return s2;
    }

    public static void info(String text) {
        InstallerLoggingUtils.info(text);
    }

    public static void help(String text) {
        InstallerLoggingUtils.help(text);
    }

    public static void error(String text) {
        InstallerLoggingUtils.error(text);
    }

    public static void debug(String text) {
        InstallerLoggingUtils.debug(text);
    }

    private static String input(String message) {
        return message + " (?):";
    }

    public static File readFileFromConsole(String message, String description) {
        System.out.print(InstallerUtils.input(message));
        try {
            File srcFile;
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            String s2 = bufferRead.readLine();
            if ("?".equals(s2) && description != null) {
                InstallerUtils.help(description);
                return InstallerUtils.readFileFromConsole(message, description);
            }
            if ("Q".equalsIgnoreCase(s2)) {
                System.exit(0);
            }
            if (!(srcFile = new File(s2)).exists()) {
                InstallerUtils.error(String.format("File %s does not exist", s2));
                return InstallerUtils.readFileFromConsole(message, description);
            }
            return srcFile;
        }
        catch (IOException e) {
            System.exit(1);
            return null;
        }
    }

    public static boolean isEncryptMode(String mode) {
        return mode != null && mode.equals("E");
    }

    public static boolean isDecryptMode(String mode) {
        return mode != null && mode.equals(CommandLineOptions.DECRYPT.getLongOption());
    }

    public static boolean isHelpMode(String mode) {
        return mode != null && mode.equals("HELP");
    }

    public static void printHelp() {
        System.out.println(InstallerMessages.scriptUsage());
        System.out.println(InstallerMessages.scriptUsageModes());
    }

    public static String getAgentVersionFromManifest(String defaultAgentVersion) throws IOException {
        try {
            Enumeration<URL> resources = InstallerUtils.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                String agentVersion;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                if (manifest.getMainAttributes().getValue("Main-Class") == null || !manifest.getMainAttributes().getValue("Main-Class").contains("AgentInstaller") || (agentVersion = manifest.getMainAttributes().getValue("Specification-Version")) == null) continue;
                return agentVersion;
            }
        }
        catch (IOException E) {
            return defaultAgentVersion;
        }
        return defaultAgentVersion;
    }

    private static List<String> generateFileList(File root, File node, List<String> fileList) {
        if (node.isFile()) {
            String file = node.getAbsoluteFile().toString();
            fileList.add(file.substring(root.getAbsolutePath().length() + 1, file.length()));
        }
        if (node.isDirectory()) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                fileList = InstallerUtils.generateFileList(root, new File(node, filename), fileList);
            }
        }
        return fileList;
    }
}

