/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.installer.AgentInstaller;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class InstallerMessages {
    public static final String MESSAGES_PROPERTIES = "messages.properties";
    private static Properties messages;

    public static void loadMessages() {
        try {
            messages = new Properties();
            messages.load(AgentInstaller.class.getClassLoader().getResourceAsStream(MESSAGES_PROPERTIES));
        }
        catch (IOException e) {
            System.exit(1);
        }
    }

    public static String noMuleHomeProvidedMessage() {
        return InstallerMessages.formatMessage("mule.home.error");
    }

    public static String notProvidedMuleHome() {
        return InstallerMessages.formatMessage("mule.home.not.specified");
    }

    public static String unExistentConfFolderMessage() {
        return InstallerMessages.formatMessage("mule.conf.error");
    }

    public static String unExistentAppsFolderMessage() {
        return InstallerMessages.formatMessage("mule.apps.error");
    }

    public static String unExistentPluginsFolderMessage() {
        return InstallerMessages.formatMessage("mule.plugins.error");
    }

    public static String pluginNotInstalledErrorMessage() {
        return InstallerMessages.formatMessage("plugin.not.installed.error");
    }

    public static String modeSelectionMessage() {
        return InstallerMessages.formatMessage("mode.message");
    }

    public static String modeSelectionHelpMessage() {
        return InstallerMessages.formatMessage("mode.description");
    }

    public static String endOfScriptMessage() {
        return InstallerMessages.formatMessage("script.end");
    }

    public static String finishUnpack() {
        return InstallerMessages.formatMessage("script.finish.installing.agent");
    }

    public static String insecureEndOfScriptMessage() {
        return InstallerMessages.formatMessage("insecure.end.message");
    }

    public static String updateEndOfScriptMessage() {
        return InstallerMessages.formatMessage("update.end.message");
    }

    public static String title() {
        return InstallerMessages.formatMessage("script.title");
    }

    public static String installingAgentPlugin() {
        return InstallerMessages.formatMessage("script.installing.agent");
    }

    public static String secureInstallerDescription() {
        return InstallerMessages.formatMessage("secure.channel.description");
    }

    public static String keystoreDescription() {
        return InstallerMessages.formatMessage("keystore.description");
    }

    public static String truststoreDescription() {
        return InstallerMessages.formatMessage("truststore.description");
    }

    private static String formatMessage(String key) {
        return String.format(messages.getProperty(key), new Object[0]);
    }

    public static String hybridDescription() {
        return InstallerMessages.formatMessage("hybrid.description");
    }

    public static String keystorePassword() {
        return InstallerMessages.formatMessage("keystore.password");
    }

    public static String keystoreAlias() {
        return InstallerMessages.formatMessage("keystore.alias");
    }

    public static String keystoreAliasPassword() {
        return InstallerMessages.formatMessage("keystore.alias.password");
    }

    public static String secureSuccessful() {
        return InstallerMessages.formatMessage("successful.secure");
    }

    public static String invalidCertificate() {
        return InstallerMessages.formatMessage("certificate.not.valid");
    }

    public static String scriptUsage() {
        return InstallerMessages.formatMessage("script.usage");
    }

    public static String scriptUsageModes() {
        return InstallerMessages.formatMessage("script.usage.modes");
    }

    public static String insecureMode() {
        return InstallerMessages.formatMessage("insecure.mode.description");
    }

    public static String secureMode() {
        return InstallerMessages.formatMessage("secure.mode.description");
    }

    public static String hybridManagementMode() {
        return InstallerMessages.formatMessage("hybrid.mode.description");
    }

    public static String trafficInspectionConfiguration() {
        return InstallerMessages.formatMessage("traffic.inspection.configuration.description");
    }

    public static String hybridFalconManagementMode() {
        return InstallerMessages.formatMessage("hybrid.falcon.description");
    }

    public static String amcHostConfiguration() {
        return InstallerMessages.formatMessage("amc.configuration.host.description");
    }

    public static String csHostConfiguration() {
        return InstallerMessages.formatMessage("cs.configuration.host.description");
    }

    public static String ccsHostConfiguration() {
        return InstallerMessages.formatMessage("ccs.configuration.host.description");
    }

    public static String apHostConfiguration() {
        return InstallerMessages.formatMessage("ap.configuration.host.description");
    }

    public static String authProxyHostConfiguration() {
        return InstallerMessages.formatMessage("authProxy.configuration.host.description");
    }

    public static String mcmHostConfiguration() {
        return InstallerMessages.formatMessage("mcm.configuration.host.description");
    }

    public static String proxyConfiguration() {
        return InstallerMessages.formatMessage("proxy.description");
    }

    public static String proxyKerberosConfiguration() {
        return InstallerMessages.formatMessage("proxy.kerberos.description");
    }

    public static String muleHomeDescription() {
        return InstallerMessages.formatMessage("mule.home.description");
    }

    public static String gatewayDescription() {
        return InstallerMessages.formatMessage("gateway.description");
    }

    public static String useHelp() {
        return InstallerMessages.formatMessage("script.usage.help");
    }

    public static String skipGatewayClientIdWrapperUpdate() {
        return InstallerMessages.formatMessage("skip.gw.coreservices.clientid");
    }

    public static String clientCredentialsEncryptionKeyDescription() {
        return InstallerMessages.formatMessage("client.credentials.encryption.key.description");
    }

    public static String environmentConfiguration(String[] availableEnvironments) {
        return String.format(messages.getProperty("environment.description"), ArrayUtils.toString(availableEnvironments));
    }

    public static String regionConfiguration(String[] availableRegions) {
        return String.format(messages.getProperty("region.description"), ArrayUtils.toString(availableRegions));
    }

    public static String encryptionConfiguration() {
        return String.format(messages.getProperty("encryption.description"), "mule-agent.yml");
    }

    public static String decryptionConfiguration() {
        return String.format(messages.getProperty("decryption.description"), "mule-agent.yml");
    }

    public static String encryptionSuccess() {
        return String.format(messages.getProperty("encryption.success"), "mule-agent.yml");
    }

    public static String encryptionFailed() {
        return String.format(messages.getProperty("encryption.failed"), new Object[0]);
    }

    public static String encryptionNoSecretsEncrypted() {
        return String.format(messages.getProperty("encryption.no.secrets.encrypted"), new Object[0]);
    }

    public static String encryptionSecretSuccess(String name) {
        return String.format(messages.getProperty("encryption.secret.success"), name);
    }

    public static String encryptionSecretFailed(String name, String message) {
        return String.format(messages.getProperty("encryption.secret.failed"), name, message);
    }

    public static String encryptionValueAlreadyEncrypted(String name) {
        return String.format(messages.getProperty("encryption.value.already.encrypted"), name);
    }

    public static String encryptionReadPassword(String name) {
        return String.format(messages.getProperty("encryption.readPassword"), name);
    }

    public static String encryptionReadPasswordDescription(String name) {
        return String.format(messages.getProperty("encryption.readPassword.description"), name);
    }

    public static String encryptionReadPasswordConfirmation(String name) {
        return String.format(messages.getProperty("encryption.readPasswordConfirmation"), name);
    }

    public static String encryptionReadPasswordConfirmationDescription(String name) {
        return String.format(messages.getProperty("encryption.readPasswordConfirmation.description"), name);
    }

    public static String encryptionDifferentPasswordError() {
        return messages.getProperty("encryption.differentPasswordError");
    }

    public static String decryptionMasterPasswordNotFound() {
        return messages.getProperty("decryption.masterPassword.notFound");
    }

    public static String encryptionError(Exception ex) {
        return ex.getMessage();
    }

    public static String updateAgentMessage(String modulesPath) {
        return String.format(messages.getProperty("script.update.message"), modulesPath);
    }

    public static String removeOldDiskBufferMessage(List<String> filesToRemove) {
        String separator = "\n\t- ";
        return String.format(messages.getProperty("disk.buffer.remove.message"), "\n\t- " + StringUtils.join(filesToRemove, "\n\t- "));
    }

    public static String truststoreExistMessage(String filename) {
        return String.format(messages.getProperty("truststore.exist"), filename);
    }

    public static String truststoreFileMustBeRenamedMessage(String oldName, String newName) {
        return String.format(messages.getProperty("truststore.must.be.renamed"), oldName, newName);
    }

    public static String truststoreRenameSuccessMessage() {
        return String.format(messages.getProperty("truststore.rename.success"), new Object[0]);
    }

    public static String truststoreNotFoundMessage() {
        return String.format(messages.getProperty("truststore.not.found"), new Object[0]);
    }

    public static String agentDescriptorDNSChangedMessage() {
        return String.format(messages.getProperty("agent.descriptor.dns.changed"), new Object[0]);
    }
}

