/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.mulesoft.agent.configuration.encryption.EncryptionServiceBuilder;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.exception.CredentialEncryptionNotSupportedException;
import com.mulesoft.agent.installer.AgentInstaller;
import com.mulesoft.agent.installer.EnvironmentInfo;
import com.mulesoft.agent.installer.HybridInstallerValidator;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.installer.ProxyInfo;
import com.mulesoft.agent.installer.ProxyKerberosInfo;
import com.mulesoft.agent.installer.RuntimeEncrypter;
import com.mulesoft.agent.installer.RuntimeEncrypterBuilder;
import com.mulesoft.agent.installer.coreservices.Credentials;
import com.mulesoft.agent.installer.keystore.KeyStoreStrategy;
import com.mulesoft.agent.installer.keystore.KeyStoreUtils;
import com.mulesoft.agent.installer.request.HybridRegistrationRequest;
import com.mulesoft.agent.installer.request.RegistrationRequestBody;
import com.mulesoft.agent.installer.request.RegistrationRequestBodyBuilder;
import com.mulesoft.agent.installer.response.RegistrationResponse;
import com.mulesoft.agent.installer.utils.InstallerCoreServicesUtils;
import com.mulesoft.agent.security.AgentSecurityManager;
import com.mulesoft.agent.security.AgentSecurityManagerBuilder;
import com.mulesoft.agent.security.model.KeyPairWrapper;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.services.MuleConfigurationService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.util.DefaultLicenseService;
import com.mulesoft.agent.util.DefaultRuntimeVersionService;
import com.mulesoft.agent.util.InstallerLoggingUtils;
import com.mulesoft.agent.util.service.DefaultMuleConfigurationService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.bouncycastle.operator.OperatorCreationException;

public class HybridInstaller
extends AgentInstaller {
    private static final String USER_AGENT = "Mozilla/5.0";
    private final String agentName;
    private final ProxyInfo proxyInfo;
    private final ProxyKerberosInfo proxyKerberosInfo;
    private final EnvironmentInfo environmentInfo;
    private final String encryptionKey;
    private String amcToken;
    private boolean isGatewayRuntime;
    private boolean isUnifiedRuntime;
    private boolean skipGatewayClientIdConf;
    private boolean activateWss = true;
    private RuntimeVersionService runtimeVersionService = new DefaultRuntimeVersionService(new DefaultLicenseService());
    private MuleConfigurationService muleConfigurationService = new DefaultMuleConfigurationService();
    private AgentSecurityManager agentSecurityManager;
    private EncryptionService encryptorService;

    public HybridInstaller(File muleHome, File confFolder, File pluginsFolder, CommandLine commandLine) {
        super(muleHome, confFolder, pluginsFolder);
        this.isGatewayRuntime = this.runtimeVersionService.isGateway(muleHome.getPath());
        this.isUnifiedRuntime = this.runtimeVersionService.isUnifiedRuntime(this.runtimeVersionService.getRuntimeVersion(muleHome.getPath()));
        String[] amcAuthOptions = commandLine.getOptionValues("H");
        this.amcToken = amcAuthOptions != null ? amcAuthOptions[0] : null;
        this.agentName = amcAuthOptions != null && amcAuthOptions.length > 1 ? amcAuthOptions[1] : null;
        String[] wssOptions = commandLine.getOptionValues("WSS");
        this.activateWss = wssOptions == null || !String.valueOf(Boolean.FALSE).equals(wssOptions[0]);
        this.proxyInfo = new ProxyInfo.ProxyInfoBuilder(commandLine).build();
        this.proxyKerberosInfo = new ProxyKerberosInfo.ProxyKerberosInfoBuilder(commandLine).build();
        this.environmentInfo = new EnvironmentInfo.EnvironmentInfoBuilder(commandLine).build();
        boolean isFipsEnabled = commandLine.hasOption("fips");
        this.agentSecurityManager = AgentSecurityManagerBuilder.newInstance().enableFips(isFipsEnabled).build();
        this.skipGatewayClientIdConf = commandLine.hasOption("skip-gateway-clientid");
        this.encryptionKey = commandLine.getOptionValue("encryption-key");
        this.encryptorService = EncryptionServiceBuilder.newInstance().build();
    }

    private RuntimeEncrypter buildRuntimeEncrypter(String muleVersion) throws CredentialEncryptionNotSupportedException {
        try {
            return RuntimeEncrypterBuilder.newInstance().addRuntimeVersionService(this.runtimeVersionService).addMuleVersion(muleVersion).addEncryptionKey(this.encryptionKey).build();
        }
        catch (CredentialEncryptionNotSupportedException e) {
            InstallerLoggingUtils.info(e.getMessage());
            return null;
        }
    }

    private RegistrationRequestBody buildRegistrationRequestBody(KeyPairWrapper keyPair, String muleVersion, String gatewayVersion, String agentVersion) throws OperatorCreationException, IOException {
        return RegistrationRequestBodyBuilder.create().withCSR(this.agentSecurityManager.generateAgentCertificateSigningRequest(keyPair)).withMuleVersion(muleVersion).withGatewayVersion(gatewayVersion).withMuleLabel(this.agentName).withAgentVersion(agentVersion).build();
    }

    private String buildProxyDescriptorContent() {
        String content = "";
        if (this.proxyInfo == null) {
            return content;
        }
        content = content + String.format("  proxyConfiguration:%n    host: %s%n    port: %s%n    trafficInspectionEnabled: %s%n", this.proxyInfo.getHost(), this.proxyInfo.getPort(), this.proxyInfo.isTrafficInspectionEnabled());
        if (this.proxyInfo.isAnonymous()) {
            return content;
        }
        content = content + String.format("    user: %s%n    password: %s%n", this.proxyInfo.getUser(), this.proxyInfo.getPassword());
        return content;
    }

    private String buildProxyKerberosDescriptorContent() {
        String content = "";
        if (this.proxyKerberosInfo == null) {
            return content;
        }
        if (this.proxyKerberosInfo != null && this.proxyKerberosInfo.isValid().booleanValue()) {
            content = content + String.format("  proxyKerberosConfiguration:%n    krb5ConfigurationPath: %s%n    jaasConfigurationPath: %s%n", this.proxyKerberosInfo.getKrb5ConfigurationPath(), this.proxyKerberosInfo.getJaasConfigurationPath());
        }
        return content;
    }

    private void generateKeystoreFiles(KeyPairWrapper keyPair, char[] keystorePassword, RegistrationResponse registration) throws Exception {
        try (InputStream certificateIS = registration.getCertificateISorElseBuild();
             InputStream caCertificateIS = registration.getNullableCaCertificateIS();){
            InputStream transformedAgentCertificate = this.agentSecurityManager.transformCSRtoCertificate(certificateIS);
            InputStream transformedCACertificate = this.agentSecurityManager.transformCSRtoCertificate(caCertificateIS);
            InputStream[] chainCertificates = registration.getNullableChainCertificatesIS();
            KeyStoreStrategy keystore = new KeyStoreStrategy.Builder(this.agentSecurityManager.getCryptographyStrategy(), this.confFolder, this.environmentInfo.isOnPrem(), this.environmentInfo.isHyperforce()).addAgentCertificate(transformedAgentCertificate).addCACertificate(transformedCACertificate, this.environmentInfo.getTrustStoreFileName()).addChainCertificates(chainCertificates).build();
            keystore.generateJKS(keyPair, keystorePassword);
            if (this.environmentInfo.isOnPrem()) {
                try {
                    String pemContent = this.getOnPremCertificate();
                    KeyStoreUtils.importOnPremTrustStores(this.confFolder.getPath(), pemContent, String.valueOf(keystorePassword), this.agentSecurityManager.getCryptographyStrategy().getKeystoreType().toString());
                }
                catch (Exception e) {
                    InstallerUtils.error(String.format("Error trying to update the truststore file %s", e.getMessage()));
                }
            }
        }
    }

    @Override
    public void install() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchAlgorithmException, AgentEncryptionException {
        this.validateExistingConfiguration();
        super.installAgentPlugin();
        this.agentSecurityManager.initialize();
        InstallerLoggingUtils.info(String.format("Fips enabled: %s", this.agentSecurityManager.isFipsEnabled()));
        if (this.environmentInfo.isHyperforce()) {
            InstallerLoggingUtils.info("Hyperforce mode enabled");
        }
        System.out.println();
        System.out.println(InstallerMessages.hybridDescription());
        String agentVersion = InstallerUtils.getAgentVersionFromManifest(InstallerUtils.getInstalledAgentVersion(this.muleHome));
        String keystorePassword = this.agentSecurityManager.generateKeystorePassword();
        String muleVersion = this.runtimeVersionService.getRuntimeVersion(this.muleHome.getPath());
        String gatewayVersion = this.runtimeVersionService.getGatewayVersion(this.muleHome.getPath());
        String keystorePasswordEncrypted = this.encryptorService.encrypt(keystorePassword);
        try {
            HybridInstallerValidator.validateAmcToken(this.amcToken);
            HybridInstallerValidator.validateServerName(this.agentName);
            RuntimeEncrypter runtimeEncrypter = this.buildRuntimeEncrypter(muleVersion);
            KeyPairWrapper keyPairWrapper = this.agentSecurityManager.generateKeyPair();
            RegistrationRequestBody registrationRequest = this.buildRegistrationRequestBody(keyPairWrapper, muleVersion, gatewayVersion, agentVersion);
            String proxyDescriptorContent = this.buildProxyDescriptorContent();
            String proxyKerberosDescriptorContent = this.buildProxyKerberosDescriptorContent();
            RegistrationResponse registration = this.registerMule(registrationRequest);
            this.environmentInfo.updateFromExternal(registration.getEnvironmentUrls());
            String descriptorContent = this.buildDescriptorContent(keystorePasswordEncrypted);
            descriptorContent = descriptorContent + proxyDescriptorContent;
            descriptorContent = descriptorContent + proxyKerberosDescriptorContent;
            this.generateKeystoreFiles(keyPairWrapper, keystorePassword.toCharArray(), registration);
            if (this.isGatewayRuntime || this.isUnifiedRuntime) {
                HashMap<String, String> wrapperProperties = new HashMap<String, String>();
                if (!this.skipGatewayClientIdConf) {
                    if (registration.isLegacyRegistration()) {
                        System.out.println("Connecting to Core Services to extract client_id and client_secret");
                        Credentials credentials = InstallerCoreServicesUtils.getCoreServicesUserInformation(this.environmentInfo, this.proxyInfo, this.proxyKerberosInfo, USER_AGENT, this.amcToken, registration.getOrgId());
                        System.out.println("Credentials extracted correctly, updating wrapper conf file");
                        registration.setClientId(credentials.getClientId());
                        registration.setClientSecret(credentials.getClientSecret());
                    }
                    String clientId = registration.getClientId();
                    String clientSecret = registration.getClientSecret();
                    if (runtimeEncrypter != null) {
                        clientId = runtimeEncrypter.encrypt(clientId);
                        clientSecret = runtimeEncrypter.encrypt(clientSecret);
                    }
                    wrapperProperties.put("anypoint.platform.client_id", clientId);
                    wrapperProperties.put("anypoint.platform.client_secret", clientSecret);
                }
                wrapperProperties.put("anypoint.platform.base_uri", this.environmentInfo.getPlatformUri());
                if (this.environmentInfo.isOnPrem()) {
                    descriptorContent = descriptorContent + String.format("%n%s: %s%n", "environment", RuntimeEnvironment.ON_PREM.getValue());
                    wrapperProperties.put("anypoint.platform.on_prem", "true");
                    wrapperProperties.put("anypoint.platform.analytics_enabled", "false");
                } else if (this.environmentInfo.isHyperforce()) {
                    descriptorContent = descriptorContent + String.format("%n%s: %s%n", "environment", RuntimeEnvironment.HYPER_FORCE.getValue());
                    wrapperProperties.put("anypoint.platform.analytics_enabled", "false");
                } else {
                    wrapperProperties.put("anypoint.platform.analytics_base_uri", this.environmentInfo.getAnalyticsUri());
                }
                this.muleConfigurationService.addWrapperJavaAdditionalProperties(this.confFolder, wrapperProperties);
            }
            try {
                FileUtils.writeStringToFile(new File(this.confFolder, "mule-agent.yml"), descriptorContent, Charset.defaultCharset());
                System.out.println("Mule Agent configuration saved successfully");
            }
            catch (IOException e) {
                InstallerUtils.error(e.getMessage());
                throw new IOException(e);
            }
        }
        catch (IllegalArgumentException e) {
            InstallerUtils.error(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RegistrationResponse registerMule(RegistrationRequestBody registrationRequest) throws IOException, NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        RegistrationResponse registration = HybridRegistrationRequest.create(this.environmentInfo.getArmConsoleUri(), this.amcToken).withRegistrationRequest(registrationRequest).withUserAgent(USER_AGENT).withProxy(this.proxyInfo, this.proxyKerberosInfo).withIsOnPrem(this.environmentInfo.isOnPrem()).post();
        if (registration.isLegacyRegistration() && this.environmentInfo.isOnPrem()) {
            registration.setCaCertificate(this.getOnPremCertificate());
        }
        return registration;
    }

    private String getOnPremCertificate() throws IOException {
        try {
            return Resources.toString(this.getClass().getClassLoader().getResource("onPrem-root.pem"), Charsets.UTF_8);
        }
        catch (IOException e) {
            System.out.println("OnPrem certificate not found in the agent.");
            throw e;
        }
    }

    private void validateEncrypter(RuntimeEncrypter runtimeEncrypter) {
        try {
            if (runtimeEncrypter != null) {
                runtimeEncrypter.encrypt(USER_AGENT);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error trying to encrypt using the given encryption configuration: %s", e.getCause().getMessage()));
        }
    }

    private void validateExistingConfiguration() {
        if (this.confFolder.list(new NameFileFilter("mule-agent.yml")).length != 0) {
            System.err.println(String.format("This mule server is already configured. Remove this server from the server list on the %nRuntime Manager UI and remove the mule-agent.yml configuration file on your conf folder.", new Object[0]));
            System.exit(1);
        }
    }

    private String buildDescriptorContent(String keystorePassword) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("---%ntransports:%n  rest.agent.transport:%n    enabled: false%n  websocket.transport:%n    enabled: %s%n    consoleUri: %s%n    handshake:%n      enabled: true%n      body:%nglobalConfiguration:%n  security:%n    keyStorePassword: %s%n    keyStoreAlias: agent%n    keyStoreAliasPassword: %s%n  authenticationProxy:%n    endpoint: %s%n  metricIngestion:%n    endpoint: %s%n", this.activateWss, this.environmentInfo.getMcmWebSocketUri(), String.format("\"%s\"", keystorePassword), String.format("\"%s\"", keystorePassword), this.environmentInfo.getAuthServicesUri(), this.environmentInfo.getMeteringServiceUri()));
        if (this.environmentInfo.isHyperforce() || this.environmentInfo.isOnPrem()) {
            sb.append(String.format("internalHandlers:%n  mule.agent.tracking.handler.analytics:%n    enabled: false%n  mule.agent.ingest.target.metrics.internal.handler:%n    enabled: false%n  mule.agent.ingest.application.metrics.internal.handler:%n    enabled: false%n", new Object[0]));
        }
        return sb.toString();
    }
}

