/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.installer.AgentInstaller;
import com.mulesoft.agent.installer.PlatformUrl;
import com.mulesoft.agent.installer.response.EnvironmentUrls;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.ArrayUtils;

public final class EnvironmentInfo {
    private PlatformUrl armConsoleUri;
    private PlatformUrl platformUri;
    private PlatformUrl analyticsUri;
    private PlatformUrl coreServicesUri;
    private PlatformUrl authServicesUri;
    private PlatformUrl mcmWebSocketUri;
    private PlatformUrl meteringServiceUri;
    private final boolean isOnPrem;
    private final boolean isHyperforce;
    private final String trustStoreFileName;

    public EnvironmentInfo(PlatformUrl platformUri, PlatformUrl analyticsUri, PlatformUrl coreServicesUri, PlatformUrl authServicesUri, PlatformUrl armConsoleUri, PlatformUrl mcmWebSocketUri, PlatformUrl meteringServiceUri, String trustStoreFileName, boolean isOnPrem, boolean isHyperforce) {
        this.platformUri = platformUri;
        this.analyticsUri = analyticsUri;
        this.coreServicesUri = coreServicesUri;
        this.authServicesUri = authServicesUri;
        this.armConsoleUri = armConsoleUri;
        this.mcmWebSocketUri = mcmWebSocketUri;
        this.meteringServiceUri = meteringServiceUri;
        this.trustStoreFileName = trustStoreFileName;
        this.isOnPrem = isOnPrem;
        this.isHyperforce = isHyperforce;
    }

    public String getPlatformUri() {
        return this.platformUri.getUrl();
    }

    public String getAnalyticsUri() {
        return this.analyticsUri.getUrl();
    }

    public String getCoreServicesUri() {
        return this.coreServicesUri.getUrl();
    }

    public String getArmConsoleUri() {
        return this.armConsoleUri.getUrl();
    }

    public String getAuthServicesUri() {
        return this.authServicesUri.getUrl();
    }

    public String getMcmWebSocketUri() {
        return this.mcmWebSocketUri.getUrl();
    }

    public String getMeteringServiceUri() {
        return this.meteringServiceUri.getUrl();
    }

    public boolean isOnPrem() {
        return this.isOnPrem;
    }

    public boolean isHyperforce() {
        return this.isHyperforce;
    }

    public String getTrustStoreFileName() {
        return this.trustStoreFileName;
    }

    public void updateFromExternal(EnvironmentUrls environmentUrls) {
        this.platformUri = this.getOverridableUrl(this.platformUri, environmentUrls.getAnypointBaseUrl());
        this.coreServicesUri = this.getOverridableUrl(this.coreServicesUri, environmentUrls.getCoreServicesUrl());
        this.analyticsUri = this.getOverridableUrl(this.analyticsUri, environmentUrls.getAnalyticsUrl());
        this.mcmWebSocketUri = this.getOverridableUrl(this.mcmWebSocketUri, environmentUrls.getMcmWebsocketUrl());
        this.authServicesUri = this.getOverridableUrl(this.authServicesUri, environmentUrls.getAuthProxyUrl());
        this.meteringServiceUri = this.getOverridableUrl(this.meteringServiceUri, environmentUrls.getIngestionServiceUrl());
    }

    private PlatformUrl getOverridableUrl(PlatformUrl defaultUrl, String serviceUrl) {
        if (serviceUrl != null && !serviceUrl.isEmpty() && !PlatformUrl.PlatformUrlSource.COMMAND_LINE.equals((Object)defaultUrl.getSource())) {
            return PlatformUrl.fromService(serviceUrl);
        }
        return defaultUrl;
    }

    public String toString() {
        return "EnvironmentInfo{platformUri='" + this.platformUri + '\'' + ", analyticsUri='" + this.analyticsUri + '\'' + ", authServicesUri='" + this.authServicesUri + '\'' + ", armConsoleUri='" + this.armConsoleUri + '\'' + ", mcmWebSocketUri='" + this.mcmWebSocketUri + '\'' + ", isOnPrem=" + this.isOnPrem + ", trustStoreFileName='" + this.trustStoreFileName + '\'' + '}';
    }

    public static class EnvironmentInfoBuilder {
        static final String ENVIRONMENT_ARG = "environment";
        static final String REGION_ARG = "region";
        static final String HYPERFORCE_ENV = "hyperforce";
        static final String ENVIRONMENT_DEFAULT = "prod";
        static final String[] ENVIRONMENT_AVAILABLE = new String[]{"local", "devx", "qax", "stgx", "stgxdr", "uat", "prod", "performance", "eu1", "it-test", "gstg"};
        static final String[] REGION_AVAILABLE = new String[]{"prod", "eu1", "us_gov"};
        private PlatformUrl platformUri;
        private final PlatformUrl analyticsUri = PlatformUrl.empty();
        private final PlatformUrl coreServicesUri;
        private final PlatformUrl authProxyServicesUri;
        private final PlatformUrl armConsoleUri;
        private final PlatformUrl mcmWebSocketUri;
        private final PlatformUrl meteringServiceUri;
        private String trustStoreFileName;
        private boolean isOnPrem;
        private boolean isHyperforce;

        public EnvironmentInfoBuilder(CommandLine commandLine) {
            this.isHyperforce = this.isHyperforce(commandLine);
            this.isOnPrem = !this.isHyperforce && commandLine.getOptionValues("A") != null;
            Properties properties = new Properties();
            if (!this.isHyperforce) {
                properties = this.loadPropertiesFromFile(commandLine);
            }
            String[] amcOptions = commandLine.getOptionValues("A");
            String amcUriProperty = properties.getProperty("hybrid.console.uri");
            this.armConsoleUri = amcOptions != null ? PlatformUrl.fromCommandLine(amcOptions[0]) : PlatformUrl.fromPropertyFile(amcUriProperty);
            String[] mcmOptions = commandLine.getOptionValues("W");
            this.mcmWebSocketUri = mcmOptions != null ? PlatformUrl.fromCommandLine(mcmOptions[0]) : PlatformUrl.empty();
            String[] csOptions = commandLine.getOptionValues("C");
            this.coreServicesUri = csOptions != null ? PlatformUrl.fromCommandLine(csOptions[0]) : PlatformUrl.empty();
            String[] authProxyOptions = commandLine.getOptionValues("Z");
            this.authProxyServicesUri = authProxyOptions != null ? PlatformUrl.fromCommandLine(authProxyOptions[0]) : PlatformUrl.empty();
            String[] apiPlatformOptions = commandLine.getOptionValues("F");
            PlatformUrl platformUrl = this.platformUri = apiPlatformOptions != null ? PlatformUrl.fromCommandLine(apiPlatformOptions[0]) : PlatformUrl.empty();
            if (this.platformUri.getUrl() != null) {
                this.platformUri = PlatformUrl.fromCommandLine(this.platformUri.getUrl().replace("/apiplatform", ""));
            }
            this.meteringServiceUri = PlatformUrl.empty();
            this.trustStoreFileName = properties.getProperty("truststore.file.name");
        }

        private Properties loadPropertiesFromFile(CommandLine commandLine) {
            Properties properties = new Properties();
            String environmentPrefix = "onPrem";
            if (!this.isOnPrem) {
                environmentPrefix = this.getEnvironmentPrefix(commandLine);
            }
            try {
                properties.load(AgentInstaller.class.getClassLoader().getResourceAsStream(environmentPrefix + ".properties"));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            return properties;
        }

        private boolean isHyperforce(CommandLine commandLine) {
            return HYPERFORCE_ENV.equalsIgnoreCase(commandLine.getOptionValue(ENVIRONMENT_ARG));
        }

        public String getEnvironmentPrefix(CommandLine commandLine) {
            String prefix = commandLine.getOptionValue(ENVIRONMENT_ARG);
            if (prefix != null) {
                if (!ArrayUtils.contains(ENVIRONMENT_AVAILABLE, prefix)) {
                    throw new IllegalArgumentException("The selected environment (" + prefix + ") is not valid. Valid environments are: " + ArrayUtils.toString(ENVIRONMENT_AVAILABLE));
                }
                return prefix;
            }
            prefix = commandLine.getOptionValue(REGION_ARG);
            if (prefix != null) {
                if (!ArrayUtils.contains(REGION_AVAILABLE, prefix)) {
                    throw new IllegalArgumentException("The selected region (" + prefix + ") is not valid. Valid regions are: " + ArrayUtils.toString(REGION_AVAILABLE));
                }
                return prefix;
            }
            return ENVIRONMENT_DEFAULT;
        }

        public EnvironmentInfo build() {
            return new EnvironmentInfo(this.platformUri, this.analyticsUri, this.coreServicesUri, this.authProxyServicesUri, this.armConsoleUri, this.mcmWebSocketUri, this.meteringServiceUri, this.trustStoreFileName, this.isOnPrem, this.isHyperforce);
        }
    }
}

