/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.installer;

import com.mulesoft.agent.configuration.Environment;
import com.mulesoft.agent.configuration.descriptor.ConfigurationEncryptor;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptorWrapper;
import com.mulesoft.agent.configuration.descriptor.YamlBuilder;
import com.mulesoft.agent.configuration.encryption.EncryptionServiceBuilder;
import com.mulesoft.agent.configuration.properties.MasterPasswordProperty;
import com.mulesoft.agent.exception.AgentException;
import com.mulesoft.agent.exception.MasterPasswordNotFoundException;
import com.mulesoft.agent.installer.EnvironmentInfo;
import com.mulesoft.agent.installer.ExtendedParser;
import com.mulesoft.agent.installer.HiddenArgumentHelpFormatter;
import com.mulesoft.agent.installer.InstallerMessages;
import com.mulesoft.agent.installer.InstallerUtils;
import com.mulesoft.agent.installer.ScriptInstaller;
import com.mulesoft.agent.installer.ScriptOption;
import com.mulesoft.agent.installer.Updater;
import com.mulesoft.agent.installer.commands.CommandLineOptions;
import com.mulesoft.agent.installer.commands.builders.AmcSetupOptionsBuilder;
import com.mulesoft.agent.installer.encryption.EncryptionCommandExecutor;
import com.mulesoft.agent.installer.encryption.KeystoreAliasPasswordEncryptionCommand;
import com.mulesoft.agent.installer.encryption.KeystorePasswordEncryptionCommand;
import com.mulesoft.agent.installer.encryption.ProxyPasswordEncryptionCommand;
import com.mulesoft.agent.services.EncryptionService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;

public abstract class AgentInstaller
implements ScriptInstaller {
    public static final String ON_PREM_ROOT_PEM = "onPrem-root.pem";
    public static final String MULE_AGENT_DESCRIPTOR_FILE = "mule-agent.yml";
    public static final String MULE_AGENT_PLUGIN = "mule-agent-plugin";
    public static final String MULE_AGENT_PLUGIN_JAR = "mule-agent-plugin.jar";
    public static final String PLUGINS_FOLDER = "server-plugins";
    public static final String CONF_FOLDER = "conf";
    protected File muleHome;
    protected File confFolder;
    protected File pluginsFolder;
    protected Path muleAgentDescriptorPath;

    public AgentInstaller(File muleHome, File confFolder, File pluginsFolder) {
        this.muleHome = muleHome;
        this.confFolder = confFolder;
        this.pluginsFolder = pluginsFolder;
    }

    public static void main(String[] args2) throws IOException {
        try {
            InstallerMessages.loadMessages();
            System.out.println(InstallerMessages.title());
            Options options = AgentInstaller.getOptions();
            ExtendedParser parser = new ExtendedParser(true);
            CommandLine commandLine = parser.parse(options, args2);
            String argMode = AgentInstaller.getMode(commandLine);
            String configurationFilename = Paths.get("..", CONF_FOLDER, MULE_AGENT_DESCRIPTOR_FILE).toString();
            AgentInstaller.invokeEncryptValueIfNeeded(argMode, commandLine.getOptionValues(CommandLineOptions.ENCRYPT.getShortOption()));
            AgentInstaller.invokeDecryptValueIfNeeded(argMode, commandLine.getOptionValues(CommandLineOptions.DECRYPT.getLongOption()));
            AgentInstaller.invokeEncryptIfNeeded(argMode, configurationFilename);
            AgentInstaller.invokeDecryptIfNeeded(argMode, configurationFilename);
            if (InstallerUtils.isHelpMode(argMode)) {
                String header = "\nTo run this script:\n- If you are not running this script under your MULE_HOME/bin folder please point to the corresponding Mule installation using the parameter --mule-home\n- Choose the mode to run\n\nExample: java -jar agent-setup.jar --mule-home /home/Users/mule-3.6.0 -H aca38879-ad5a-4f34-ab4e-298a24ebaeb myMule \n";
                String footer = "";
                HiddenArgumentHelpFormatter formatter = new HiddenArgumentHelpFormatter("environment");
                formatter.setWidth(160);
                ((HelpFormatter)formatter).printHelp("Mule Agent Installer", header, options, footer, true);
                System.exit(0);
            }
            System.out.println(InstallerMessages.useHelp());
            String muleHome = AgentInstaller.getMuleHome(commandLine);
            File muleHomeFolder = InstallerUtils.getMandatoryFolder(new File(muleHome), InstallerMessages.noMuleHomeProvidedMessage());
            File confFolder = InstallerUtils.getMandatoryFolder(new File(muleHome, CONF_FOLDER), InstallerMessages.unExistentConfFolderMessage());
            File pluginsFolder = InstallerUtils.getMandatoryFolder(new File(muleHome, PLUGINS_FOLDER), InstallerMessages.unExistentPluginsFolderMessage());
            ScriptOption.thatMatchesWith(argMode.toUpperCase()).runOn(muleHomeFolder, confFolder, pluginsFolder, commandLine);
        }
        catch (ParseException e) {
            InstallerUtils.error("Invalid options");
            InstallerUtils.error(InstallerMessages.endOfScriptMessage());
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            InstallerUtils.error(InstallerMessages.endOfScriptMessage());
        }
    }

    private static void invokeEncryptIfNeeded(String argMode, String configurationFilename) {
        if (InstallerUtils.isEncryptMode(argMode)) {
            AgentInstaller.encrypt(configurationFilename);
            System.exit(0);
        }
    }

    private static void invokeEncryptValueIfNeeded(String argMode, String[] encryptOptions) {
        if (InstallerUtils.isEncryptMode(argMode)) {
            if (encryptOptions == null) {
                return;
            }
            try {
                MasterPasswordProperty masterPasswordProperty = MasterPasswordProperty.newInstance(Environment.getInstance());
                masterPasswordProperty.orElseThrow(() -> new MasterPasswordNotFoundException(InstallerMessages.decryptionMasterPasswordNotFound()));
                EncryptionService encryptorService = EncryptionServiceBuilder.newInstance().build();
                String plainValue = encryptOptions[0];
                String encryptedValue = encryptorService.encrypt(plainValue);
                InstallerUtils.info(String.format("The encrypted value to paste on the mule-agent.yml file is: '%s'", encryptedValue));
                System.exit(0);
            }
            catch (Exception ex) {
                InstallerUtils.error(InstallerMessages.encryptionError(ex));
                InstallerUtils.error(InstallerMessages.endOfScriptMessage());
                System.exit(-1);
            }
        }
    }

    private static void invokeDecryptValueIfNeeded(String argMode, String[] encryptOptions) {
        if (InstallerUtils.isDecryptMode(argMode)) {
            if (encryptOptions == null) {
                return;
            }
            try {
                MasterPasswordProperty masterPasswordProperty = MasterPasswordProperty.newInstance(Environment.getInstance());
                masterPasswordProperty.orElseThrow(() -> new MasterPasswordNotFoundException(InstallerMessages.decryptionMasterPasswordNotFound()));
                EncryptionService encryptorService = EncryptionServiceBuilder.newInstance().build();
                String encryptedValue = encryptOptions[0];
                String plainValue = encryptorService.decrypt(encryptedValue);
                InstallerUtils.info(String.format("Plain value: '%s'", plainValue));
                System.exit(0);
            }
            catch (Exception ex) {
                InstallerUtils.error(InstallerMessages.encryptionError(ex));
                InstallerUtils.error(InstallerMessages.endOfScriptMessage());
                System.exit(-1);
            }
        }
    }

    private static void invokeDecryptIfNeeded(String argMode, String configurationFilename) {
        if (InstallerUtils.isDecryptMode(argMode)) {
            AgentInstaller.decrypt(configurationFilename);
            System.exit(0);
        }
    }

    private static String getMode(CommandLine commandLine) {
        if (commandLine.hasOption("H")) {
            return "H";
        }
        if (commandLine.hasOption("I")) {
            return "I";
        }
        if (commandLine.hasOption("S")) {
            return "S";
        }
        if (commandLine.hasOption("U")) {
            return "U";
        }
        if (commandLine.hasOption("E")) {
            return "E";
        }
        if (commandLine.hasOption(CommandLineOptions.DECRYPT.getLongOption())) {
            return CommandLineOptions.DECRYPT.getLongOption();
        }
        return "HELP";
    }

    private static String getMuleHome(CommandLine commandLine) {
        if (commandLine.hasOption("mule-home")) {
            return commandLine.getOptionValue("mule-home");
        }
        InstallerUtils.info("MULE_HOME is set as " + new File(System.getProperty("user.dir")).getParent());
        return new File(System.getProperty("user.dir")).getParent();
    }

    public void installAgentPlugin() throws IOException {
        InstallerUtils.debug(InstallerMessages.installingAgentPlugin());
        File muleAgentPackage = new File(this.pluginsFolder.getPath(), MULE_AGENT_PLUGIN_JAR);
        File muleAgentFolder = new File(this.pluginsFolder.getPath(), MULE_AGENT_PLUGIN);
        this.cleanUpMuleAgentInstallation(muleAgentPackage, muleAgentFolder);
        InstallerUtils.unzip(this.packagedMuleAgent(), muleAgentFolder);
        InstallerUtils.debug(InstallerMessages.finishUnpack());
    }

    private InputStream packagedMuleAgent() {
        return AgentInstaller.class.getClassLoader().getResourceAsStream(MULE_AGENT_PLUGIN_JAR);
    }

    private void cleanUpMuleAgentInstallation(File muleAgentPackage, File muleAgentFolder) throws IOException {
        FileUtils.deleteDirectory(muleAgentFolder);
        FileUtils.deleteDirectory(muleAgentPackage);
    }

    public static Options getOptions() {
        String pluginPath = "MULE_HOME" + File.separator + PLUGINS_FOLDER + File.separator + MULE_AGENT_PLUGIN;
        String modulesPath = pluginPath + File.separator + Updater.MULE_AGENT_MODULES_DIRECTORY;
        return AmcSetupOptionsBuilder.newInstance(modulesPath, EnvironmentInfo.EnvironmentInfoBuilder.ENVIRONMENT_AVAILABLE, EnvironmentInfo.EnvironmentInfoBuilder.REGION_AVAILABLE).build();
    }

    private static void encrypt(String configurationFilename) {
        try {
            ConfigurationEncryptor configurationEncryptor = AgentInstaller.buildConfigurationEncryptor(configurationFilename);
            EncryptionCommandExecutor executor = AgentInstaller.buildEncryptionCommandExecutor(configurationEncryptor);
            executor.execute();
            if (executor.isAnyError()) {
                InstallerUtils.error(String.format(InstallerMessages.encryptionFailed(), new Object[0]));
                return;
            }
            if (executor.isAnySecretEncrypted()) {
                InstallerUtils.info(String.format(InstallerMessages.encryptionSuccess(), new Object[0]));
                return;
            }
            InstallerUtils.info(String.format(InstallerMessages.encryptionNoSecretsEncrypted(), new Object[0]));
        }
        catch (Exception ex) {
            InstallerUtils.error(InstallerMessages.encryptionError(ex));
            InstallerUtils.error(InstallerMessages.endOfScriptMessage());
            System.exit(-1);
        }
    }

    private static void decrypt(String configurationFilename) {
        try {
            MasterPasswordProperty masterPasswordProperty = MasterPasswordProperty.newInstance(Environment.getInstance());
            masterPasswordProperty.orElseThrow(() -> new MasterPasswordNotFoundException(InstallerMessages.decryptionMasterPasswordNotFound()));
            EncryptionService encryptorService = EncryptionServiceBuilder.newInstance().build();
            MuleAgentDescriptorWrapper.newInstance(YamlBuilder.newInstance().buildYamlWrapper()).addPasswordEncryptor(encryptorService).load(configurationFilename).decryptPasswords().print(System.console().writer());
            System.console().writer().println();
        }
        catch (Exception e) {
            InstallerUtils.error(e.getMessage());
        }
        System.exit(-1);
    }

    private static ConfigurationEncryptor buildConfigurationEncryptor(String muleAgentDescriptorFile) throws IOException, AgentException {
        MasterPasswordProperty masterPasswordProperty = MasterPasswordProperty.newInstance(Environment.getInstance());
        masterPasswordProperty.orElseThrow(() -> new MasterPasswordNotFoundException(InstallerMessages.decryptionMasterPasswordNotFound()));
        EncryptionService encryptorService = EncryptionServiceBuilder.newInstance().build();
        return MuleAgentDescriptorWrapper.newInstance(YamlBuilder.newInstance().buildYamlWrapper()).addPasswordEncryptor(encryptorService).load(muleAgentDescriptorFile).toConfigurationEncryptor();
    }

    private static EncryptionCommandExecutor buildEncryptionCommandExecutor(ConfigurationEncryptor configurationEncryptor) {
        return EncryptionCommandExecutor.newInstance().addCommand(new KeystorePasswordEncryptionCommand(configurationEncryptor)).addCommand(new KeystoreAliasPasswordEncryptionCommand(configurationEncryptor)).addCommand(new ProxyPasswordEncryptionCommand(configurationEncryptor));
    }

    public static String readPasswordWithConfirmation(String name) {
        String passwordConfirmation;
        String password = InstallerUtils.readPassword(InstallerMessages.encryptionReadPassword(name), InstallerMessages.encryptionReadPasswordDescription(name));
        if (!password.equals(passwordConfirmation = InstallerUtils.readPassword(InstallerMessages.encryptionReadPasswordConfirmation(name), InstallerMessages.encryptionReadPasswordConfirmationDescription(name)))) {
            InstallerUtils.error(InstallerMessages.encryptionDifferentPasswordError());
            System.exit(-1);
        }
        System.console().printf("\n", new Object[0]);
        return password;
    }
}

