/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.domain.tooling;

import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;

public final class TestConnectionStatus {
    private final boolean validationStatus;
    private final String message;
    private final ErrorType errorType;
    private final String exception;

    private TestConnectionStatus(boolean validationStatus, String message, ErrorType errorType, String exception) {
        Preconditions.checkNotNull(validationStatus, "validationStatus cannot be null");
        this.validationStatus = validationStatus;
        this.message = message;
        this.errorType = errorType;
        this.exception = exception;
    }

    public static TestConnectionStatus testConnectionResult(ConnectionValidationResult connectionValidationResult, boolean includeException) {
        Preconditions.checkNotNull(connectionValidationResult, "connectionValidationResult cannot be null");
        return new TestConnectionStatus(connectionValidationResult.isValid(), connectionValidationResult.getMessage(), connectionValidationResult.getErrorType().orElse(null), includeException && connectionValidationResult.getException() != null ? ExceptionUtils.getStackTrace(connectionValidationResult.getException()) : null);
    }

    public boolean isValid() {
        return this.validationStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<ErrorType> getErrorType() {
        return Optional.ofNullable(this.errorType);
    }

    public String getException() {
        return this.exception;
    }
}

