/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.verifier;

import com.mulesoft.agent.configuration.verifier.VerifierAlgorithm;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationVerifier {
    public static final Logger LOGGER = LogManager.getLogger(ConfigurationVerifier.class);
    private final Map configured;
    private final Map<String, Object> loaded;
    private final List<VerifierAlgorithm> verifierAlgorithms;

    public ConfigurationVerifier(Map configuredHandlers) {
        this.configured = configuredHandlers;
        this.loaded = new HashMap<String, Object>();
        this.verifierAlgorithms = new ArrayList<VerifierAlgorithm>();
    }

    public void addVerificationAlgorithm(@NotNull VerifierAlgorithm algorithm) {
        if (this.verifierAlgorithms.contains(algorithm)) {
            return;
        }
        this.verifierAlgorithms.add(algorithm);
    }

    public synchronized boolean addComponent(@NotNull String componentName, @NotNull Class clazz) {
        if (!InternalMessageHandler.class.isAssignableFrom(clazz)) {
            return false;
        }
        this.loaded.put(componentName, null);
        return true;
    }

    public List<String> getConfigurationErrors() {
        ArrayList<String> configurationErrors = new ArrayList<String>();
        for (VerifierAlgorithm algorithm : this.verifierAlgorithms) {
            try {
                configurationErrors.addAll(algorithm.verify(this.configured, this.loaded));
            }
            catch (Exception ex) {
                LOGGER.error("There was an error verifying the configuration using: " + algorithm.getClass(), (Throwable)ex);
            }
        }
        return configurationErrors;
    }
}

