/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.multibindings.Multibinder;
import com.mulesoft.agent.configuration.guice.ModuleProvider;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.util.IOCUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public abstract class BaseModuleProvider
implements ModuleProvider {
    private Matcher matcher;

    @Override
    public final List<Module> getModules(Matcher matcher) {
        this.matcher = matcher;
        return Collections.singletonList(new AgentModule());
    }

    protected abstract void configureModule(Binder var1);

    protected <T> ScopedBindingBuilder bindNamed(Binder binder, TypeLiteral<T> api, Class<? extends T> type) {
        if (this.matcher.matches(type)) {
            return binder.bind(api).annotatedWith(this.getName(type)).to(type);
        }
        return null;
    }

    protected <T> ScopedBindingBuilder bindNamed(Binder binder, Class<T> api, Class<? extends T> type) {
        if (this.matcher.matches(type)) {
            return binder.bind(api).annotatedWith(this.getName(type)).to(type);
        }
        return null;
    }

    protected <T> void bindNamedSingleton(Binder binder, TypeLiteral<T> api, Class<? extends T> type) {
        ScopedBindingBuilder builder = this.bindNamed(binder, api, type);
        if (builder != null) {
            builder.in(Scopes.SINGLETON);
        }
    }

    protected <T> void bindNamedSingleton(Binder binder, Class<T> api, Class<? extends T> type) {
        ScopedBindingBuilder builder = this.bindNamed(binder, api, type);
        if (builder != null) {
            builder.in(Scopes.SINGLETON);
        }
    }

    protected void bindExternalHandler(Binder binder, Class<? extends ExternalMessageHandler> handlerType) {
        this.multiBind(binder, ExternalMessageHandler.class, handlerType);
    }

    protected void bindConcreteService(Binder binder, Class<? extends MuleAgentService> serviceType) {
        this.multiBind(binder, MuleAgentService.class, serviceType);
    }

    protected void bindService(Binder binder, Class<?> api, Class<? extends MuleAgentService> serviceType) {
        if (this.matcher.matches(serviceType)) {
            this.bindConcreteService(binder, serviceType);
            binder.bind(api).to(serviceType).in(Scopes.SINGLETON);
        }
    }

    protected void bindInternalHandler(Binder binder, Class<? extends InternalMessageHandler> handlerType, TypeLiteral apiType) {
        this.bindUntypedInternalHandler(binder, handlerType);
        Multibinder multibinder = Multibinder.newSetBinder(binder, apiType);
        multibinder.addBinding().to(handlerType).in(Scopes.SINGLETON);
        binder.bind(apiType).annotatedWith(this.getName(handlerType)).to(handlerType).in(Scopes.SINGLETON);
    }

    private void bindUntypedInternalHandler(Binder binder, Class<? extends InternalMessageHandler> handlerType) {
        this.multiBind(binder, InternalMessageHandler.class, handlerType);
        binder.bind(handlerType).annotatedWith(this.getName(handlerType)).to(handlerType).in(Scopes.SINGLETON);
    }

    protected void bindTransport(Binder binder, Class<? extends AgentTransport> transportType) {
        this.multiBind(binder, AgentTransport.class, transportType);
    }

    private <T> void multiBind(Binder binder, Class<T> api, Class<? extends T> type) {
        if (this.matcher.matches(type)) {
            Multibinder<T> multibinder = Multibinder.newSetBinder(binder, api);
            multibinder.addBinding().to(type).in(Scopes.SINGLETON);
        }
    }

    protected Annotation getName(Class type) {
        return IOCUtils.getNamedAnnotation(type);
    }

    private final class AgentModule
    extends AbstractModule {
        private AgentModule() {
        }

        @Override
        public void configure() {
            BaseModuleProvider.this.configureModule(this.binder());
        }

        public String toString() {
            return BaseModuleProvider.this.getClass().getName();
        }
    }
}

