/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.descriptor;

import com.mulesoft.agent.configuration.descriptor.validator.DescriptorNotEmptyValidator;
import com.mulesoft.agent.configuration.descriptor.validator.DescriptorValidator;
import com.mulesoft.agent.configuration.descriptor.validator.YamlDescriptorValidator;
import com.mulesoft.agent.configuration.descriptor.validator.exception.DescriptorValidationException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class YamlWrapper {
    protected static final String SWAP_DESCRIPTOR_NAME_FORMAT = ".%s.swp";
    public static final Logger LOGGER = LogManager.getLogger(YamlWrapper.class);
    private List<DescriptorValidator> validators = new ArrayList<DescriptorValidator>();
    private Yaml yaml;

    private YamlWrapper(Yaml yaml) {
        this.yaml = yaml;
        this.validators.add(new DescriptorNotEmptyValidator());
        this.validators.add(YamlDescriptorValidator.of(yaml));
    }

    public static YamlWrapper newInstance(Yaml yaml) {
        return new YamlWrapper(yaml);
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public Map<String, Object> load(Reader io) {
        return (Map)this.yaml.load(io);
    }

    public void dump(Map<String, Object> configuration, Writer ouput) {
        this.yaml.dump(configuration, ouput);
    }

    public void dumpSafe(Map<String, Object> configuration, Path descriptor) throws IOException {
        this.dumpSafe(configuration, descriptor, true);
    }

    protected void dumpSafe(Map<String, Object> configuration, Path descriptor, boolean removeSwapFile) throws IOException {
        if (configuration == null || configuration.isEmpty()) {
            return;
        }
        Path swap = this.buildSwapDescriptor(descriptor);
        this.dumpToFile(configuration, swap);
        this.validateDescriptorFile(swap);
        this.copyDescriptor(swap, descriptor);
        this.validateDescriptorFile(descriptor);
        if (removeSwapFile) {
            Files.delete(swap);
        }
    }

    protected void validateDescriptorFile(Path descriptorFilePath) {
        for (DescriptorValidator validator : this.validators) {
            try {
                validator.validateDescriptor(descriptorFilePath);
            }
            catch (Exception validationException) {
                throw new DescriptorValidationException(String.format("Validation of YAML descriptor for file %s in safe dump failed", descriptorFilePath.getFileName()), validationException);
            }
        }
    }

    protected void dumpToFile(Map<String, Object> configuration, Path swap) throws IOException {
        try (FileWriter fileWriter = new FileWriter(swap.toAbsolutePath().toString());){
            this.yaml.dump(configuration, fileWriter);
        }
    }

    protected Path buildSwapDescriptor(Path fromDescriptor) {
        String swapFilename = String.format(SWAP_DESCRIPTOR_NAME_FORMAT, fromDescriptor.getFileName().toString());
        return Paths.get(fromDescriptor.getParent().toString(), swapFilename);
    }

    protected void copyDescriptor(Path source2, Path destination) throws IOException {
        Files.copy(source2, destination, StandardCopyOption.REPLACE_EXISTING);
    }
}

