/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration;

import com.google.inject.MembersInjector;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class PrimitiveInjector<T>
implements MembersInjector<T> {
    protected final Field field;
    protected Object value;
    protected String componentName;
    protected MuleAgentDescriptor muleAgentDescriptor;

    public PrimitiveInjector(Field field, Object value, String componentName, MuleAgentDescriptor muleAgentDescriptor) {
        this.field = field;
        this.value = value;
        this.componentName = componentName;
        this.muleAgentDescriptor = muleAgentDescriptor;
        field.setAccessible(true);
    }

    @Override
    public void injectMembers(T t2) {
        try {
            this.value = this.setNestedValues(this.value, this.field.getGenericType(), this.componentName + "." + this.field.getName());
            this.field.set(t2, this.value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object setNestedValues(Object parent, Type parentType, String qualifierName) {
        if (parent == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(parent.getClass())) {
            for (Object propertyName : System.getProperties().keySet()) {
                if (!propertyName.getClass().equals(String.class) || !((String)propertyName).startsWith(qualifierName)) continue;
                Type mapType = ((ParameterizedType)parentType).getActualTypeArguments()[1];
                ((Map)parent).put(((String)propertyName).replace(qualifierName + ".", ""), this.muleAgentDescriptor.getStringFieldValue((Class)mapType, System.getProperty((String)propertyName)));
            }
        }
        try {
            Field[] fields;
            Method method = PrimitiveInjector.class.getDeclaredMethod(parent.getClass().getName(), Boolean.TYPE);
            method.setAccessible(true);
            for (Field nestedField : fields = (Field[])method.invoke(Field.class, false)) {
                Object nestedFieldValue;
                String systemPropertyValue = System.getProperty(String.format("%s.%s", qualifierName, nestedField.getName()));
                if (!nestedField.isAnnotationPresent(Configurable.class)) continue;
                if (systemPropertyValue != null) {
                    nestedField.set(parent, this.muleAgentDescriptor.getStringFieldValue(nestedField, systemPropertyValue));
                }
                if ((nestedFieldValue = nestedField.get(parent)) == null) continue;
                nestedField.set(parent, this.setNestedValues(nestedFieldValue, nestedField.getGenericType(), qualifierName + "." + nestedField.getName()));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return parent;
    }
}

