/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration;

import com.google.common.collect.Lists;
import com.google.inject.matcher.AbstractMatcher;
import com.mulesoft.agent.configuration.NotAvailableOn;
import com.mulesoft.agent.configuration.RuntimeEnvironmentProvider;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import java.util.List;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotAvailableMatcher<T>
extends AbstractMatcher<Class<T>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<RuntimeEnvironment> currentEnvironments;

    public NotAvailableMatcher(RuntimeEnvironmentProvider runtimeEnvironmentProvider) {
        this.currentEnvironments = Lists.newArrayList(runtimeEnvironmentProvider.getRuntimeEnvironment());
        LOGGER.debug("Current environments: '{}'.", (Object)this.currentEnvironments);
    }

    @Override
    public boolean matches(Class<T> clazz) {
        NotAvailableOn notAvailableOn = clazz.getAnnotation(NotAvailableOn.class);
        if (notAvailableOn == null || notAvailableOn.environment() == null || notAvailableOn.environment().length == 0) {
            return true;
        }
        if (Lists.newArrayList(notAvailableOn.environment()).containsAll(this.currentEnvironments)) {
            Named namedAnnotation = clazz.getAnnotation(Named.class);
            String componentName = namedAnnotation == null ? clazz.getName() : namedAnnotation.value();
            LOGGER.debug("Component '{}' is disabled since isn't available on the environments: '{}'.", (Object)componentName, (Object)notAvailableOn);
            return false;
        }
        return true;
    }
}

