/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PrimitiveInjector;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMethodPrimitiveInjector<T>
extends PrimitiveInjector<T> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultMethodPrimitiveInjector.class);

    public DefaultMethodPrimitiveInjector(Field field, Object value, String componentName, MuleAgentDescriptor muleAgentDescriptor) {
        super(field, value, componentName, muleAgentDescriptor);
    }

    @Override
    public void injectMembers(T t2) {
        try {
            Configurable configurable = this.field.getAnnotation(Configurable.class);
            if (configurable != null && configurable.method().length() > 0) {
                try {
                    Object methodReturnValue = t2.getClass().getMethod(configurable.method(), new Class[0]).invoke(t2, new Object[0]);
                    this.field.set(t2, methodReturnValue);
                }
                catch (Throwable e) {
                    LOGGER.warn("You have annotated the field " + this.field.getName() + " of class " + this.field.getClass().getName() + " as configurable with a method, but that method cannot be executed because of this exception '" + e.getMessage() + "' the default valueis going to be set ");
                    this.field.set(t2, this.value);
                }
            } else {
                this.field.set(t2, this.value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

