/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LiteTimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();
    private final AtomicBoolean signalNeeded = new AtomicBoolean(false);
    private final long timeoutInNanos;

    public LiteTimeoutBlockingWaitStrategy(long timeout2, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence2, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long availableSequence;
        long nanos = this.timeoutInNanos;
        if (cursorSequence.get() < sequence2) {
            this.lock.lock();
            try {
                while (cursorSequence.get() < sequence2) {
                    this.signalNeeded.getAndSet(true);
                    barrier.checkAlert();
                    if ((nanos = this.processorNotifyCondition.awaitNanos(nanos)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence2) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        if (this.signalNeeded.getAndSet(false)) {
            this.lock.lock();
            try {
                this.processorNotifyCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String toString() {
        return "LiteTimeoutBlockingWaitStrategy{processorNotifyCondition=" + this.processorNotifyCondition + '}';
    }
}

