/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.service;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.common.SecurityConfiguration;
import com.mulesoft.agent.domain.certificates.CertificateRenewalRequest;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.security.AgentSecurityManager;
import com.mulesoft.agent.security.AgentSecurityManagerBuilder;
import com.mulesoft.agent.services.AdministrationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.operator.ContentSigner;

@Singleton
@Named(value="internal.certificate.manager.service")
public class AgentCertificateManagerService {
    private static final Logger LOGGER = LogManager.getLogger(AgentCertificateManagerService.class);
    private static final String CONFIGURATION_FOLDER_PROPERTY = "mule.agent.configuration.folder";
    public static final String KEYSTORE_FILE = "mule-agent.jks";
    private static final String DESCRIPTOR_FILE = "mule-agent.yml";
    public static final String CERTIFICATE_ALIAS = "agent";
    public static final String DATE_FORMAT = "YYYY-MM-dd_hh-mm-ss";
    public static final String FILE_BACKUP_FORMAT = "%s.%s";
    @Configurable(value="{}")
    private SecurityConfiguration security;
    private AgentSecurityManager agentSecurityManager = AgentSecurityManagerBuilder.newInstance().useFipsConfigurationProperty().build();
    @Inject
    private AdministrationService administrationService;

    public CertificateRenewalRequest getRenewAgentCertificateRequest(KeyPair keyPair) throws Exception {
        String confFolder = System.getProperty(CONFIGURATION_FOLDER_PROPERTY);
        String keystoreFilePath = confFolder + File.separator + KEYSTORE_FILE;
        LOGGER.debug("Renew Certificate - keystoreFilePath: {} ", (Object)keystoreFilePath);
        char[] keystorePassword = this.administrationService.decrypt(this.security.getKeyStorePassword());
        LOGGER.debug("Renew Certificate - getting keystore ");
        KeyStore jks = KeyStore.getInstance(this.agentSecurityManager.getCryptographyStrategy().getKeystoreType().name());
        LOGGER.debug("Renew Certificate - loading keystore ");
        jks.load(new FileInputStream(keystoreFilePath), keystorePassword);
        LOGGER.debug("Renew Certificate - getting certificate {}", (Object)CERTIFICATE_ALIAS);
        Certificate certificate = jks.getCertificate(CERTIFICATE_ALIAS);
        LOGGER.debug("Renew Certificate - generating signing request");
        String signRequest = this.generateCertificateSigningRequestAsString(keyPair);
        LOGGER.debug("Renew Certificate - creating certificate renewal request");
        CertificateRenewalRequest certificateRenewalRequest = new CertificateRenewalRequest(AgentCertificateManagerService.toPem(certificate), signRequest);
        return certificateRenewalRequest;
    }

    public KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.agentSecurityManager.getCryptographyStrategy().generateKeyPair();
    }

    public String generateCertificateSigningRequestAsString(KeyPair keyPair) throws Exception {
        ContentSigner sigGen = this.agentSecurityManager.getCryptographyStrategy().buildContentSigner(keyPair.getPrivate());
        return this.agentSecurityManager.getCryptographyStrategy().buildAgentCertificateSigningRequestAsString(keyPair.getPublic(), sigGen);
    }

    public void generateJKS(File confFolder, InputStream certificateInputStream, KeyPair keyPair) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, NoSuchProviderException, AgentEncryptionException {
        LOGGER.debug("Renew Certificate - decrypting");
        char[] keystorePassword = this.administrationService.decrypt(this.security.getKeyStorePassword());
        LOGGER.debug("Renew Certificate - transforming certificate");
        InputStream transformedCertificate = this.agentSecurityManager.transformCSRtoCertificate(certificateInputStream);
        LOGGER.debug("Renew Certificate - generating new certificate");
        List certificates = (List)this.agentSecurityManager.getCryptographyStrategy().getCertificateFactoryInstance().generateCertificates(transformedCertificate);
        LOGGER.debug("Renew Certificate - getting keystore");
        KeyStore keyStore = this.agentSecurityManager.getCryptographyStrategy().getKeystoreInstance();
        LOGGER.debug("Renew Certificate - loading keystore");
        keyStore.load(null, keystorePassword);
        LOGGER.debug("Renew Certificate - certificate  chain");
        Certificate[] certChain = new Certificate[certificates.size()];
        certificates.toArray(certChain);
        LOGGER.debug("Renew Certificate - setting entry");
        keyStore.setKeyEntry(CERTIFICATE_ALIAS, keyPair.getPrivate(), keystorePassword, certChain);
        LOGGER.debug("Renew Certificate - Creating new certificate file");
        FileOutputStream keystoreFile = new FileOutputStream(new File(confFolder, KEYSTORE_FILE));
        LOGGER.debug("Renew Certificate - storing new certificate");
        keyStore.store(keystoreFile, keystorePassword);
        LOGGER.debug("Renew Certificate - closing new keystore file");
        keystoreFile.close();
    }

    public void backupJKS(File confFolder) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date date = new Date();
        String dateSuffix = dateFormat.format(date);
        Path keystorePath = Paths.get(confFolder.getPath() + File.separator + KEYSTORE_FILE, new String[0]);
        Path keystoreBackup = Paths.get(String.format(FILE_BACKUP_FORMAT, confFolder + File.separator + KEYSTORE_FILE, dateSuffix), new String[0]);
        Files.copy(keystorePath, keystoreBackup, StandardCopyOption.REPLACE_EXISTING);
    }

    /*
     * Exception decompiling
     */
    private static String toPem(Object object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

