/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.clients.adapters.OkHttpCallAsyncHttpResponseAdapter;
import com.mulesoft.agent.util.client.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.Response;

public final class KerberosAuthenticationProxyClient
implements AuthenticationProxyClient {
    private static final Logger LOGGER = LogManager.getLogger(KerberosAuthenticationProxyClient.class);
    private final URI baseUrl;
    private final OkHttpClient okHttpClient;
    private final ObjectMapper objectMapper;

    KerberosAuthenticationProxyClient(URI baseUrl, OkHttpClient client, ObjectMapper objectMapper) {
        this.baseUrl = baseUrl;
        this.okHttpClient = client;
        this.objectMapper = objectMapper;
    }

    public <T> Response post(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().header("Accept", "application/json");
            KerberosAuthenticationProxyClient.addHeaders(headers, requestBuilder);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])this.objectMapper.writeValueAsBytes(body));
            requestBuilder.url(URIUtils.concatenateBaseUrlAndPath(this.baseUrl, path)).post(requestBody);
            Request request = requestBuilder.build();
            OkHttpCallAsyncHttpResponseAdapter legacyResponseAdapter = new OkHttpCallAsyncHttpResponseAdapter().performRequest(this.okHttpClient, request);
            return legacyResponseAdapter;
        }
        catch (IOException e) {
            LOGGER.warn("There was an error sending post request to the auth proxy.");
            LOGGER.debug("There was an error sending post request to the auth proxy.", (Throwable)e);
            throw new RuntimeException("There was an error sending post request to the auth proxy", e);
        }
    }

    public <T> Response post(String path, T body) {
        return this.post(path, body, new HashMap<CharSequence, Collection<String>>(0));
    }

    public <T> Response put(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().header("Accept", "application/json");
            KerberosAuthenticationProxyClient.addHeaders(headers, requestBuilder);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])this.objectMapper.writeValueAsBytes(body));
            requestBuilder.url(URIUtils.concatenateBaseUrlAndPath(this.baseUrl, path)).put(requestBody);
            Request request = requestBuilder.build();
            OkHttpCallAsyncHttpResponseAdapter legacyResponseAdapter = new OkHttpCallAsyncHttpResponseAdapter().performRequest(this.okHttpClient, request);
            return legacyResponseAdapter;
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("There was an error serializing the request body.");
            LOGGER.debug("There was an error serializing the request body.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOGGER.warn("There was an error sending post request to the auth proxy.");
            LOGGER.debug("There was an error sending post request to the auth proxy.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T> Response put(String path, T body) {
        return this.put(path, body, new HashMap<CharSequence, Collection<String>>(0));
    }

    public void close() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        if (this.okHttpClient.cache() != null) {
            try {
                this.okHttpClient.cache().close();
            }
            catch (IOException e) {
                LOGGER.error("The connection could not be closed.");
                LOGGER.debug("The connection could not be closed.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static void addHeaders(Map<CharSequence, Collection<String>> headers, Request.Builder requestBuilder) {
        headers.forEach((charSequence, strings) -> {
            if (strings.isEmpty()) {
                requestBuilder.header(charSequence.toString(), "");
            } else {
                strings.forEach(s -> requestBuilder.addHeader(charSequence.toString(), s));
            }
        });
    }
}

