/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.ssl.SSLContextLoader;
import com.mulesoft.agent.util.client.DefaultAuthenticationProxyClient;
import com.mulesoft.agent.util.client.DefaultAuthenticationProxyUtil;
import com.mulesoft.agent.util.client.KerberosAuthenticationProxyClient;
import com.mulesoft.agent.util.client.okhttp.HTTPSUtils;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import okhttp3.OkHttpClient;
import org.asynchttpclient.AsyncHttpClient;

enum AuthenticationProxyFactoryStrategy {
    CLIENT_ASYNCHTTP{

        @Override
        AuthenticationProxyClient create(URI endpoint, ProxyAuthConfiguration proxyAuthConfiguration, SSLContext sslContext, SSLContextLoader sslContextLoader, ObjectMapper objectMapper) throws URISyntaxException {
            AsyncHttpClient client = DefaultAuthenticationProxyUtil.buildAsyncHttpClient(sslContext, proxyAuthConfiguration);
            return new DefaultAuthenticationProxyClient(endpoint, client, objectMapper, proxyAuthConfiguration);
        }
    }
    ,
    CLIENT_OKHTTP{

        @Override
        AuthenticationProxyClient create(URI endpoint, ProxyAuthConfiguration proxyAuthConfiguration, SSLContext sslContext, SSLContextLoader sslContextLoader, ObjectMapper objectMapper) {
            OkHttpClient client = HTTPSUtils.buildHttpClient(proxyAuthConfiguration);
            client = HTTPSUtils.configureMutualTlsInHttpClient(client, sslContext, sslContextLoader.getTrustManagerFactory());
            return new KerberosAuthenticationProxyClient(endpoint, client, objectMapper);
        }
    };


    abstract AuthenticationProxyClient create(URI var1, ProxyAuthConfiguration var2, SSLContext var3, SSLContextLoader var4, ObjectMapper var5) throws URISyntaxException;
}

