/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class WrapperPropertiesUtils {
    public static final String WRAPPER_PROPERTY_PREFIX = "-D";
    public static final String WRAPPER_CONF_JAVA_ADDITIONAL = "wrapper.java.additional.";
    public static final String WRAPPER_CONF_JAVA_ADDITIONAL_FOR_REGEX = "wrapper.java.additional.".replaceAll("\\.", "\\.");
    private static final Pattern WRAPPER_ADDITIONAL_JAVA_PATTERN_TRUNCATED = Pattern.compile(WRAPPER_CONF_JAVA_ADDITIONAL_FOR_REGEX + "[0-9]+");
    private static final Pattern WRAPPER_ADDITIONAL_JAVA_PATTERN = Pattern.compile(WRAPPER_ADDITIONAL_JAVA_PATTERN_TRUNCATED + "(=.+)?");
    private static final Pattern WRAPPER_ADDITIONAL_JAVA_PATTERN_WITH_SUFFIX = Pattern.compile(WRAPPER_CONF_JAVA_ADDITIONAL_FOR_REGEX + "[0-9]+((\\.stripquotes)|((\\.java_version\\.)(min|max)))(=.+)?");

    private WrapperPropertiesUtils() {
    }

    public static boolean isWrapperAdditionalJavaProperty(String text) {
        Matcher matcher = WRAPPER_ADDITIONAL_JAVA_PATTERN.matcher(text);
        return matcher.matches();
    }

    public static boolean isWrapperAdditionalJavaPropertyTruncated(String text) {
        Matcher matcher = WRAPPER_ADDITIONAL_JAVA_PATTERN_TRUNCATED.matcher(text);
        return matcher.matches();
    }

    public static boolean isWrapperAdditionalJavaPropertyWithSuffix(String text) {
        Matcher matcher = WRAPPER_ADDITIONAL_JAVA_PATTERN_WITH_SUFFIX.matcher(text);
        return matcher.matches();
    }

    public static String buildProperty(int index, String key, String value) {
        return String.format("%s%s=%s%s=%s", WRAPPER_CONF_JAVA_ADDITIONAL, index, WRAPPER_PROPERTY_PREFIX, key, value);
    }

    public static int getWrapperAdditionalJavaPropertyIndex(String propertyKey) {
        return Integer.parseInt(StringUtils.substringBefore((String)StringUtils.substringAfter((String)propertyKey.split("=")[0], (String)WRAPPER_CONF_JAVA_ADDITIONAL_FOR_REGEX), (String)"."));
    }

    public static String removeDPrefixFromKey(String propertyKey) {
        if (propertyKey.startsWith(WRAPPER_PROPERTY_PREFIX)) {
            propertyKey = propertyKey.substring(WRAPPER_PROPERTY_PREFIX.length());
        }
        return propertyKey;
    }

    public static String getWrapperAdditionalJavaPropertySuffix(String line) {
        return StringUtils.substringAfter((String)StringUtils.substringAfter((String)line.split("=")[0], (String)WRAPPER_CONF_JAVA_ADDITIONAL_FOR_REGEX), (String)".");
    }

    public static boolean lineContainsEntry(String line, Map.Entry<String, String> entry) {
        return StringUtils.contains((String)line, (String)String.format("=%s%s=%s", WRAPPER_PROPERTY_PREFIX, WrapperPropertiesUtils.removeDPrefixFromKey(entry.getKey()), entry.getValue()));
    }
}

