/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util;

import com.google.inject.Inject;
import com.mulesoft.agent.services.LicenseService;
import com.mulesoft.agent.services.RuntimeVersionService;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.module.deployment.api.DeploymentService;

@Named(value="internal.service.version")
@Singleton
public final class DefaultRuntimeVersionService
implements RuntimeVersionService {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MULE_UNIFIED_RUNTIME_VERSION = "3.8.0-SNAPSHOT";
    public static final String CLUSTERING_PORT_VERSION = "3.8.5-SNAPSHOT";
    public static final String MULE_4_1_0 = "4.1.0-SNAPSHOT";
    public static final String MULE_4_1_3 = "4.1.3-SNAPSHOT";
    public static final String MULE_4_1_5 = "4.1.5-SNAPSHOT";
    public static final String MULE_4_2_0 = "4.2.0-SNAPSHOT";
    public static final String GW_LICENSE_ENTITLEMENT = "api-gateway";
    private static final String GW_VERSION_PROPERTY = "gateway.version";
    private static final String MULE_VERSION_PREFIX = "mule-core-ee-";
    private static final String GW_VERSION_PREFIX = "gateway-core-";
    private final LicenseService muleLicenseUtils;
    private static final String REDEPLOY_METHOD_NAME = "redeploy";

    @Inject
    public DefaultRuntimeVersionService(LicenseService muleLicenseUtils) {
        this.muleLicenseUtils = muleLicenseUtils;
    }

    public String getRuntimeVersion() {
        return MuleManifest.getProductVersion();
    }

    public String getRuntimeVersion(String muleHome) {
        File dir = new File(muleHome, "lib/mule");
        WildcardFileFilter fileFilter = new WildcardFileFilter("mule-core-ee-*.jar");
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files == null || files.length == 0) {
            throw new IllegalStateException(String.format("Unable to read files from %s/lib/mule/", muleHome));
        }
        return files[0].getName().substring(MULE_VERSION_PREFIX.length(), files[0].getName().lastIndexOf(46));
    }

    @Deprecated
    public String getGatewayVersion() {
        if (this.isUnifiedRuntime() && this.isGateway()) {
            return this.getRuntimeVersion();
        }
        if (this.isUnifiedRuntime()) {
            return "";
        }
        String gatewayVersion = System.getProperty(GW_VERSION_PROPERTY);
        if (gatewayVersion == null) {
            return "";
        }
        return gatewayVersion;
    }

    @Deprecated
    public String getGatewayVersion(String muleHome) {
        String runtimeVersion = this.getRuntimeVersion(muleHome);
        if (!this.isUnifiedRuntime(runtimeVersion)) {
            File dir = new File(muleHome, "lib/mule");
            WildcardFileFilter fileFilter = new WildcardFileFilter("gateway-core-*.jar");
            File[] files = dir.listFiles((FileFilter)fileFilter);
            if (files.length == 0) {
                return null;
            }
            return files[0].getName().substring(GW_VERSION_PREFIX.length(), files[0].getName().lastIndexOf(46));
        }
        if (this.isGateway(muleHome)) {
            return runtimeVersion;
        }
        return null;
    }

    public boolean isGateway() {
        if (!this.isUnifiedRuntime()) {
            String gatewayVersion = System.getProperty(GW_VERSION_PROPERTY);
            return StringUtils.isNotEmpty((String)gatewayVersion);
        }
        return this.muleLicenseUtils.hasEntitlement(GW_LICENSE_ENTITLEMENT);
    }

    public boolean isGateway(String muleHome) {
        String runtimeVersion = this.getRuntimeVersion(muleHome);
        if (!this.isUnifiedRuntime(runtimeVersion)) {
            String gatewayVersion = this.getGatewayVersion(muleHome);
            return StringUtils.isNotEmpty((String)gatewayVersion);
        }
        return false;
    }

    public boolean isUnifiedRuntime() {
        return this.isUnifiedRuntime(this.getRuntimeVersion());
    }

    public boolean isUnifiedRuntime(String runtimeVersion) {
        return this.isVersionGreaterOrEqualThan(runtimeVersion, MULE_UNIFIED_RUNTIME_VERSION);
    }

    public boolean supportsClusteringPort() {
        return this.isCurrentVersionGreaterOrEqualThan(CLUSTERING_PORT_VERSION);
    }

    public boolean supportsSchedulingManagement() {
        return this.isCurrentVersionGreaterOrEqualThan(MULE_4_1_0);
    }

    public boolean supportsApplicationDeploymentProperties() {
        return this.isCurrentVersionGreaterOrEqualThan(MULE_4_1_0);
    }

    public boolean supportsToolingApplicationDeploymentProperties() {
        return this.isCurrentVersionGreaterOrEqualThan(MULE_4_1_5);
    }

    public boolean supportsDataWeaveMaxCollectionSize() {
        return this.isCurrentVersionGreaterOrEqualThan(MULE_4_1_3);
    }

    public boolean supportsEncryptedCredentials(String muleVersion) {
        return this.isVersionGreaterOrEqualThan(muleVersion, MULE_4_2_0);
    }

    public boolean supportsExpressionSession() {
        return this.isCurrentVersionGreaterOrEqualThan(MULE_4_2_0);
    }

    public boolean supportsReducedTypeSerialization() {
        return this.isCurrentVersionGreaterOrEqualThan(MULE_4_2_0);
    }

    private boolean isCurrentVersionGreaterOrEqualThan(String minimumVersionString) {
        return this.isVersionGreaterOrEqualThan(this.getRuntimeVersion(), minimumVersionString);
    }

    private boolean isVersionGreaterOrEqualThan(String runtimeVersion, String minimumVersionString) {
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(runtimeVersion);
        DefaultArtifactVersion minimumVersion = new DefaultArtifactVersion(minimumVersionString);
        boolean isCurrentVersionGreaterOrEqualThan = currentVersion.compareTo((ArtifactVersion)minimumVersion) >= 0;
        LOGGER.debug("The version {} is greater than {}? {}", (Object)runtimeVersion, (Object)minimumVersion, (Object)isCurrentVersionGreaterOrEqualThan);
        return isCurrentVersionGreaterOrEqualThan;
    }

    public boolean supportsApplicationRedeployment() {
        try {
            DeploymentService.class.getDeclaredMethod(REDEPLOY_METHOD_NAME, URI.class, Properties.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

