/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.connection;

import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import com.mulesoft.connectors.ws.api.client.WebSocketClientSettings;
import com.mulesoft.connectors.ws.internal.WebSocketsConnector;
import com.mulesoft.connectors.ws.internal.client.OutboundSocketCallback;
import com.mulesoft.connectors.ws.internal.client.WebSocketClient;
import com.mulesoft.connectors.ws.internal.connection.OnCloseListenerRegistry;
import com.mulesoft.connectors.ws.internal.connection.OutboundSocketListener;
import com.mulesoft.connectors.ws.internal.connection.ReconnectableWebSocketDecorator;
import com.mulesoft.connectors.ws.internal.connection.SocketRegistry;
import com.mulesoft.connectors.ws.internal.connection.WebSocketState;
import com.mulesoft.connectors.ws.internal.error.WsError;
import com.mulesoft.connectors.ws.internal.server.ForwardingWebSocketHandler;
import com.mulesoft.connectors.ws.internal.server.OnCloseCallback;
import com.mulesoft.connectors.ws.internal.server.WebSocketServer;
import com.mulesoft.connectors.ws.internal.util.RetryPolicyHelper;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.authentication.UsernamePasswordAuthentication;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxCapacitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluxCapacitor.class);
    private final WebSocketServer webSocketServer;
    private final WebSocketClient webSocketClient;
    private final SocketRegistry registry;
    private final Map<String, ForwardingWebSocketHandler> inboundHandlers = new ConcurrentHashMap<String, ForwardingWebSocketHandler>();
    private final OutboundSocketListener outboundSocketListener;
    private final OnCloseListenerRegistry onCloseListenerRegistry;
    private final HttpService httpService;
    private final Scheduler reconnectionScheduler;

    public FluxCapacitor(WebSocketServer webSocketServer, WebSocketClient webSocketClient, HttpService httpService, Scheduler reconnectionScheduler) {
        this.webSocketServer = webSocketServer;
        this.webSocketClient = webSocketClient;
        this.httpService = httpService;
        this.reconnectionScheduler = reconnectionScheduler;
        this.registry = new SocketRegistry(httpService);
        this.outboundSocketListener = new OutboundSocketListener(httpService);
        this.onCloseListenerRegistry = new OnCloseListenerRegistry(httpService);
    }

    public CompletableFuture<WebSocketAttributes> openOutboundSocket(WebSocketsConnector config, HttpClient client, HttpRequest request, List<String> defaultGroups, Optional<String> socketId, int responseTimeout) {
        WebSocketClientSettings settings = this.unsafeGetWebSocketClient(config).getSettings();
        HttpRequestOptions options = HttpRequestOptions.builder().responseTimeout(responseTimeout).followsRedirect(settings.isFollowRedirects()).authentication(this.resolveAuthentication(settings.getAuthentication())).build();
        String wsId = socketId.orElseGet(() -> WebSocketUtils.getSocketId((WebSocketsConnector)config, (String)request.getUri().getPath()));
        if (wsId == null || wsId.trim().length() == 0) {
            throw new ModuleException("Socket ID cannot be null or blank", (ErrorTypeDefinition)WsError.INVALID_SOCKET_ID);
        }
        OutboundSocketCallback callback = new OutboundSocketCallback(this, this.outboundSocketListener, request, defaultGroups, settings);
        CompletableFuture futureSocket = client.openWebSocket(request, options, wsId, (WebSocketCallback)callback);
        return futureSocket.thenApply(socket -> {
            WebSocketAttributes attributes = callback.getSocketAttributes();
            this.subscribeGroups((WebSocket)socket, defaultGroups);
            socket = new ReconnectableWebSocketDecorator((WebSocket)socket, this);
            this.notifyOpen(new WebSocketState(socket, attributes));
            return attributes;
        });
    }

    public CompletableFuture<Void> send(String socketId, InputStream content, MediaType mediaType) {
        return this.send(this.lookupWebSocket(socketId), content, mediaType);
    }

    public CompletableFuture<Void> send(WebSocket socket, InputStream content, MediaType mediaType) {
        if (content == null) {
            throw new IllegalArgumentException("The content to be sent through a WebSocket cannot be null");
        }
        return socket.send(content, mediaType);
    }

    public CompletableFuture<Void> broadcast(TypedValue<InputStream> content, String path, Predicate<WebSocket> socketFilter, RetryPolicyTemplate retryPolicyTemplate, BiConsumer<WebSocket, Throwable> errorCallback) {
        Collection sockets = this.registry.lookup(path, socketFilter);
        return RetryPolicyHelper.broadcast(this.httpService.newWebSocketBroadcaster(), sockets, content, errorCallback, retryPolicyTemplate, this.reconnectionScheduler);
    }

    public CompletableFuture<Void> bulkCloseSockets(Predicate<WebSocket> socketFilter, WebSocketCloseCode closeCode, String reason) {
        Collection sockets = this.registry.lookup(socketFilter);
        sockets.forEach(socket -> this.doClose((WebSocket)socket, closeCode, reason));
        return CompletableFuture.completedFuture(null);
    }

    public void registerOnCloseCallback(String path, OnCloseCallback callback) {
        this.onCloseListenerRegistry.registerOnCloseCallback(path, callback);
    }

    public void unregisterOnCloseCallback(String path, OnCloseCallback callback) {
        this.onCloseListenerRegistry.unregisterOnCloseCallback(path, callback);
    }

    public CompletableFuture<Void> close(String socketId, WebSocketCloseCode closeCode, String reason) {
        return this.doClose(this.lookupWebSocket(socketId), closeCode, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> doClose(WebSocket socket, WebSocketCloseCode closeCode, String reason) {
        try {
            CompletableFuture completableFuture = socket.close(closeCode, reason);
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture completableFuture = WebSocketUtils.failedFuture((Throwable)e);
            return completableFuture;
        }
        finally {
            this.notifyClosed(socket, closeCode, reason, true);
        }
    }

    public void registerInboundHandler(String path, ForwardingWebSocketHandler handler) {
        if (this.inboundHandlers.putIfAbsent(path, handler) != null) {
            throw new IllegalStateException("An inbound handler already exists for path " + path);
        }
    }

    public void unregisterInboundHandler(String path) {
        this.inboundHandlers.remove(path);
    }

    public Optional<ForwardingWebSocketHandler> getInboundHandler(String path) {
        return Optional.ofNullable(this.inboundHandlers.get(path));
    }

    public void subscribeGroups(WebSocket socket, List<String> groups) {
        if (groups != null) {
            groups.forEach(arg_0 -> ((WebSocket)socket).addGroup(arg_0));
        }
    }

    public CompletableFuture<WebSocket> reconnectOnFailure(String socketId, WebSocketConnectionException e, RetryPolicyTemplate retryPolicyTemplate) {
        return this.reconnectOnFailure(socketId, e, retryPolicyTemplate, this.reconnectionScheduler);
    }

    public CompletableFuture<WebSocket> reconnectOnFailure(String socketId, WebSocketConnectionException e, RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        try {
            WebSocket webSocket = this.registry.getSocket(socketId);
            if (webSocket.supportsReconnection()) {
                return RetryPolicyHelper.reconnect(webSocket, retryPolicyTemplate, scheduler).whenComplete((newSocket, re) -> {
                    if (re != null) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn(String.format("Failed to reconnect WebSocket '%s'", socketId), re);
                        }
                        this.notifyClosed(webSocket, WebSocketCloseCode.PROTOCOL_ERROR, e.getMessage(), true);
                    }
                });
            }
            this.close(socketId, WebSocketCloseCode.PROTOCOL_ERROR, e.getMessage());
            return WebSocketUtils.failedFuture((Throwable)new IllegalArgumentException("WebSocket is not reconnectable"));
        }
        catch (Throwable t) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Found exception trying to reconnect WebSocket '%s'", socketId), t);
            }
            return WebSocketUtils.failedFuture((Throwable)t);
        }
    }

    public void unsubscribeGroups(WebSocket socket, List<String> groups) {
        if (groups != null) {
            groups.forEach(arg_0 -> ((WebSocket)socket).removeGroup(arg_0));
        }
    }

    public OutboundSocketListener getOutboundSocketListener() {
        return this.outboundSocketListener;
    }

    public void notifyOpen(WebSocketState state) {
        this.registry.registerSocket(state);
    }

    public void notifyClosed(WebSocket socket, WebSocketCloseCode code, String reason, boolean unregister) {
        WebSocketState state;
        WebSocketState webSocketState = state = unregister ? this.registry.unregisterSocket(socket) : this.registry.getSocketState(socket.getId());
        if (state != null) {
            this.onCloseListenerRegistry.forEach(socket.getUri().getPath(), c -> c.onClose(state, code, reason));
        }
    }

    public void close() {
        try {
            this.registry.forEach(socket -> socket.close(WebSocketCloseCode.ENDPOINT_GOING_DOWN, "").whenComplete((v, e) -> {
                if (e != null && LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("Failed to close socket '%s' while disposing configuration: %s", socket.getId(), e.getMessage()), e);
                }
            }));
        }
        finally {
            this.stopClient();
        }
    }

    public WebSocket lookupWebSocket(String socketId) {
        return this.registry.getSocket(socketId);
    }

    public Optional<WebSocketServer> getWebSocketServer() {
        return Optional.ofNullable(this.webSocketServer);
    }

    public Optional<WebSocketClient> getWebSocketClient() {
        return Optional.ofNullable(this.webSocketClient);
    }

    public WebSocketServer unsafeGetWebSocketServer(WebSocketsConnector config) {
        return this.getWebSocketServer().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Server connection settings were not defined for WebSocket connector " + config.getName()))));
    }

    public WebSocketClient unsafeGetWebSocketClient(WebSocketsConnector config) {
        return this.getWebSocketClient().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Client connection settings were not defined for WebSocket connector " + config.getName()))));
    }

    private void stopClient() {
        block3: {
            if (this.webSocketClient != null) {
                try {
                    this.webSocketClient.getHttpClient().stop();
                }
                catch (Throwable t) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Found exception trying to stop http client: " + t.getMessage(), t);
                }
            }
        }
    }

    private HttpAuthentication resolveAuthentication(HttpRequestAuthentication authentication) {
        HttpAuthentication requestAuthentication = null;
        if (authentication instanceof UsernamePasswordAuthentication) {
            requestAuthentication = (HttpAuthentication)authentication;
        }
        return requestAuthentication;
    }
}

