/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.postconfigure;

import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.configuration.postconfigure.PostConfigureInfo;
import com.mulesoft.agent.configuration.postconfigure.PostConfigureRunner;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.handlers.InitializableInternalMessageHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPostConfigureRunner
implements PostConfigureRunner {
    public static final Logger LOGGER = LogManager.getLogger(DefaultPostConfigureRunner.class);

    @Override
    public void run(PostConfigureInfo postConfigureInfo) {
        if (postConfigureInfo.getComponentClass().getSuperclass() != null) {
            PostConfigureInfo postConfigureInfo2 = new PostConfigureInfo(postConfigureInfo.getComponentName(), postConfigureInfo.getComponentInstance(), postConfigureInfo.getComponentClass().getSuperclass());
            this.run(postConfigureInfo2);
        }
        for (Method method : postConfigureInfo.getComponentClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostConfigure.class)) continue;
            try {
                method.invoke(postConfigureInfo.getComponentInstance(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Cannot run the method " + postConfigureInfo.getComponentClass().getName() + "#" + method.getName() + " annotated as PostConfigure, the method must be public.", (Throwable)e);
                return;
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Cannot run the method " + postConfigureInfo.getComponentClass().getName() + "#" + method.getName() + " annotated as PostConfigure, check if the method is public with no parameters", e.getCause());
                return;
            }
        }
        if (postConfigureInfo.getComponentClass() == postConfigureInfo.getComponentInstance().getClass() && InitializableInternalMessageHandler.class.isAssignableFrom(postConfigureInfo.getComponentClass())) {
            InitializableInternalMessageHandler initializableInternalMessageHandler = (InitializableInternalMessageHandler)postConfigureInfo.getComponentInstance();
            if (!initializableInternalMessageHandler.isEnabled()) {
                LOGGER.info("Skipping the initialization of the " + postConfigureInfo.getComponentName() + " Internal Handler because it's disabled.");
                return;
            }
            try {
                LOGGER.info("Initializing the " + postConfigureInfo.getComponentName() + " ...");
                initializableInternalMessageHandler.initialize();
                LOGGER.info(postConfigureInfo.getComponentName() + " initialized successfully.");
            }
            catch (Exception ex) {
                String errorMessage = "There was an error initializing the " + postConfigureInfo.getComponentName() + " Internal Handler. It'll be disabled until reconfiguration. " + ex.getMessage();
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
                if (rootCause != null) {
                    errorMessage = errorMessage + "\nRoot Cause: " + rootCause.getMessage();
                }
                LOGGER.error(errorMessage);
                LOGGER.debug(ex.getMessage(), (Throwable)ex);
                try {
                    initializableInternalMessageHandler.enable(false);
                }
                catch (AgentEnableOperationException e) {
                    LOGGER.error("There was an error disabling the " + postConfigureInfo.getComponentName() + " Internal Handler.", (Throwable)e);
                }
            }
        }
    }
}

