/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.encryption;

import com.mulesoft.agent.configuration.encryption.EncryptionUtils;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.services.EncryptionService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NullEncryptionService
implements EncryptionService {
    public static final Logger LOGGER = LogManager.getLogger(NullEncryptionService.class);

    public String encrypt(String value) throws AgentEncryptionException {
        LOGGER.warn("The value cannot be encrypted since there is no Master Password provided on the Mule start up.");
        return value;
    }

    public String decrypt(String value) throws AgentEncryptionException {
        return this.decrypt(value.toCharArray());
    }

    public String decrypt(char[] value) throws AgentEncryptionException {
        StringBuilder valueAsString = new StringBuilder().append(value);
        if (EncryptionUtils.isEncryptedWithUnknownCipher(valueAsString.toString())) {
            throw new AgentEncryptionException("The value '" + valueAsString.toString() + "' cannot be decrypted since no Master Password was provided at Mule start up.");
        }
        return valueAsString.toString();
    }
}

