/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.descriptor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Password;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.configuration.descriptor.YamlBuilder;
import com.mulesoft.agent.configuration.descriptor.YamlWrapper;
import com.mulesoft.agent.domain.scheduler.Scheduler;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.jackson.SchedulerDeserializerSerializer;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.transport.AgentTransport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class YamlMuleAgentDescriptor
implements MuleAgentDescriptor {
    public static final Logger LOGGER = LogManager.getLogger(YamlMuleAgentDescriptor.class);
    public static final String YAML_FILE_EXTENSION = ".yml";
    private Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Scheduler.class, (Object)new SchedulerDeserializerSerializer()).create();
    private String descriptorPath;
    private String confFolder;
    private String parentDescriptorName;
    private EncryptionService encryptionService;
    private Yaml yaml;

    public YamlMuleAgentDescriptor(String confFolder, String parentDescriptorName, EncryptionService encryptionService) {
        this.confFolder = confFolder;
        this.parentDescriptorName = parentDescriptorName;
        this.descriptorPath = this.buildDescriptorPath(parentDescriptorName).toString();
        this.encryptionService = encryptionService;
        this.yaml = YamlBuilder.newInstance().build();
    }

    @Override
    public Object getFieldValue(Field field, Object fieldValue) {
        if (this.isPassword(field)) {
            return this.decrypt(field, fieldValue);
        }
        Class<?> type = field.getType();
        return this.gson.fromJson(this.gson.toJsonTree(fieldValue), type);
    }

    @Override
    public Object getStringFieldValue(Field field, String fieldValue) {
        if (this.isPassword(field)) {
            return this.decrypt(field, fieldValue);
        }
        try {
            Object stringValue = this.gson.fromJson(fieldValue, field.getType());
            if (stringValue == null) {
                stringValue = this.getFieldValue(field, fieldValue);
            }
            return stringValue;
        }
        catch (JsonSyntaxException e) {
            return this.getFieldValue(field, fieldValue);
        }
    }

    @Override
    public Object getStringFieldValue(Type type, String fieldValue) {
        try {
            return this.gson.fromJson(fieldValue, type);
        }
        catch (JsonSyntaxException e) {
            return this.gson.fromJson(this.gson.toJsonTree((Object)fieldValue), type);
        }
    }

    @Override
    public void removeApplicationConfigurationFile(String appName) throws IllegalAccessException {
        String configurationFilePath = this.buildApplicationDescriptorPath(appName).toString();
        if (configurationFilePath.equals(this.descriptorPath)) {
            throw new IllegalAccessException("Attempt to remove mule agent descriptor.");
        }
        File configurationFile = new File(configurationFilePath);
        if (configurationFile.exists()) {
            if (configurationFile.delete()) {
                LOGGER.debug("Application configuration file of application {} was deleted", (Object)appName);
            } else {
                LOGGER.warn("Could not delete application configuration file for the application {}.", (Object)appName);
            }
        } else {
            LOGGER.debug("Application configuration file does not exists for the application {}.", (Object)appName);
        }
    }

    @Override
    public Map load() {
        return this.loadFromFilename(this.descriptorPath);
    }

    @Override
    public Map loadFromFragment(String applicationName) {
        String applicationYamlFilename = this.buildApplicationDescriptorPath(applicationName).toString();
        return this.loadFromFilename(applicationYamlFilename);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Map<Object, Object> loadFromFilename(String filename) {
        try (FileReader reader = new FileReader(filename);){
            Map configurationMap = (Map)this.yaml.load((Reader)reader);
            if (configurationMap == null) {
                throw new IllegalStateException(String.format("Configuration file %s has an invalid format.", filename));
            }
            Map map = configurationMap;
            return map;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Descriptor file {} not found.", (Object)filename);
            return new HashMap<Object, Object>();
        }
        catch (IOException io) {
            throw new IllegalStateException(String.format("Could not read configuration file %s.", filename));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Configuration file %s has an invalid format.", filename));
        }
    }

    public boolean updateConfiguration(Map configuration, Class clazz, Field field, Object newValue) throws Exception {
        boolean updated = false;
        Named annotation = clazz.getAnnotation(Named.class);
        if (annotation == null) {
            return false;
        }
        String componentType = this.getComponentType(clazz);
        if (componentType == null) {
            return false;
        }
        Map componentTypeConfiguration = (Map)configuration.get(componentType);
        if (componentTypeConfiguration == null) {
            configuration.put(componentType, new HashMap());
            componentTypeConfiguration = (Map)configuration.get(componentType);
            updated = true;
        }
        if (newValue != null) {
            Object value;
            if (!componentTypeConfiguration.containsKey(annotation.value()) || componentTypeConfiguration.get(annotation.value()) == null) {
                componentTypeConfiguration.put(annotation.value(), new HashMap());
            }
            if (this.isPassword(field)) {
                value = this.encrypt(field, newValue);
            } else {
                Configurable fieldAnnotation = field.getAnnotation(Configurable.class);
                if (fieldAnnotation != null && Objects.equals(fieldAnnotation.value(), "{}")) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    value = objectMapper.convertValue(newValue, (TypeReference)new TypeReference<Map<String, Object>>(){});
                } else {
                    value = newValue;
                }
            }
            ((Map)componentTypeConfiguration.get(annotation.value())).put(field.getName(), value);
            updated = true;
        } else if (componentTypeConfiguration.containsKey(annotation.value())) {
            ((Map)componentTypeConfiguration.get(annotation.value())).remove(field.getName());
            if (((Map)componentTypeConfiguration.get(annotation.value())).isEmpty()) {
                componentTypeConfiguration.remove(annotation.value());
            }
            updated = true;
        }
        return updated;
    }

    @Override
    public synchronized void setFieldValue(Class clazz, Field field, Object newValue) {
        Map agentConfiguration = this.load();
        Path descriptor = Paths.get(this.descriptorPath, new String[0]);
        try {
            if (this.updateConfiguration(agentConfiguration, clazz, field, newValue)) {
                YamlWrapper.newInstance(this.yaml).dumpSafe(agentConfiguration, descriptor);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to write data to descriptor file: {}. ", (Object)this.descriptorPath, (Object)e);
        }
    }

    @Override
    public synchronized void setFieldValue(Class clazz, Field field, Object newValue, String applicationName) {
        String applicationYamlFilename = this.buildApplicationDescriptorPath(applicationName).toString();
        Path descriptor = Paths.get(applicationYamlFilename, new String[0]);
        Map<Object, Object> appAgentConfiguration = this.loadFromFilename(applicationYamlFilename);
        try {
            if (this.updateConfiguration(appAgentConfiguration, clazz, field, newValue)) {
                YamlWrapper.newInstance(this.yaml).dumpSafe(appAgentConfiguration, descriptor);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to write data to descriptor file: " + applicationYamlFilename, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
        }
    }

    private String decrypt(Field field, Object value) {
        if (value != null && value.getClass().isAssignableFrom(String.class)) {
            try {
                return this.encryptionService.decrypt((String)value);
            }
            catch (AgentEncryptionException e) {
                LOGGER.error("There was an error decrypting the password for the field '" + field.getName() + "' of class '" + field.getDeclaringClass().getName() + "'.");
            }
        } else if (value != null) {
            LOGGER.error("You have annotated the field '" + field.getName() + "' of class '" + field.getDeclaringClass().getName() + "' as a password; but the field isn't of type String");
        }
        return null;
    }

    private String encrypt(Field field, Object value) throws Exception {
        if (value != null && value.getClass().isAssignableFrom(String.class)) {
            try {
                return this.encryptionService.encrypt((String)value);
            }
            catch (AgentEncryptionException e) {
                throw new Exception("There was an error encrypting the password for the field '" + field.getName() + "' of class '" + field.getDeclaringClass().getName() + "'.");
            }
        }
        if (value != null) {
            throw new Exception("You have annotated the field '" + field.getName() + "' of class '" + field.getDeclaringClass().getName() + "' as a password; but the field isn't of type String");
        }
        return null;
    }

    private boolean isPassword(Field field) {
        return field.getAnnotation(Password.class) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map loadParentDescriptor() {
        if (this.descriptorPath == null) {
            LOGGER.warn("Descriptor file location not set, starting with default configuration.");
            return new HashMap();
        }
        try (FileReader descriptorPathFileReader = new FileReader(this.descriptorPath);){
            Map agentConfig = (Map)this.yaml.load((Reader)descriptorPathFileReader);
            if (agentConfig == null) {
                throw new IllegalStateException("Agent configuration file has an invalid format.");
            }
            Map map = agentConfig;
            return map;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Descriptor file not found, starting with default configuration.");
            return new HashMap();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not read configuration file %s.", this.descriptorPath));
        }
        catch (Exception e) {
            throw new IllegalStateException("Agent configuration file has an invalid format.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map loadAppAgentConfiguration(String applicationName) {
        String appConfigurationYml = this.buildApplicationDescriptorPath(applicationName).toString();
        try (FileReader appConfigurationYmlFileReader = new FileReader(appConfigurationYml);){
            Map appAgentConfiguration = (Map)this.yaml.load((Reader)appConfigurationYmlFileReader);
            if (appAgentConfiguration == null) {
                throw new IllegalStateException("Application configuration file has an invalid format.");
            }
            Map map = appAgentConfiguration;
            return map;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Descriptor file for application {} not found.", (Object)applicationName);
            return new HashMap();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not read application configuration file %s.", appConfigurationYml));
        }
    }

    private void merge(Map<String, Object> agentConfiguration, Map<String, Object> appConfiguration) {
        for (String key : appConfiguration.keySet()) {
            Object appValue = appConfiguration.get(key);
            if (agentConfiguration.containsKey(key)) {
                Object agentValue = agentConfiguration.get(key);
                if (agentValue instanceof Map && appValue instanceof Map) {
                    this.merge((Map)agentValue, (Map)appValue);
                    continue;
                }
                if (agentValue instanceof List && appValue instanceof List) {
                    ((List)agentValue).removeAll((List)appValue);
                    ((List)appValue).addAll((List)agentValue);
                    agentConfiguration.put(key, appValue);
                    continue;
                }
                agentConfiguration.put(key, appValue);
                continue;
            }
            agentConfiguration.put(key, appValue);
        }
    }

    private String getComponentType(Class clazz) {
        String componentType = null;
        if (MuleAgentService.class.isAssignableFrom(clazz)) {
            componentType = "services";
        } else if (AgentTransport.class.isAssignableFrom(clazz)) {
            componentType = "transports";
        } else if (InternalMessageHandler.class.isAssignableFrom(clazz)) {
            componentType = "internalHandlers";
        } else if (ExternalMessageHandler.class.isAssignableFrom(clazz)) {
            componentType = "externalHandlers";
        }
        return componentType;
    }

    private Path buildDescriptorPath(String filename) {
        return Paths.get(this.confFolder, filename);
    }

    private Path buildApplicationDescriptorPath(String applicationName) {
        String filename = applicationName + YAML_FILE_EXTENSION;
        return this.buildDescriptorPath(filename);
    }
}

