/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration;

import com.mulesoft.agent.configuration.RuntimeEnvironmentProvider;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultRuntimeEnvironmentProvider
implements RuntimeEnvironmentProvider {
    private static final Logger LOGGER = LogManager.getLogger(DefaultRuntimeEnvironmentProvider.class);
    static final String REST_TRANSPORT_CONFIG_KEY = "rest.agent.transport";
    static final String WEBSOCKET_TRANSPORT_CONFIG_KEY = "websocket.transport";
    static final String ENABLED_FIELD_NAME = "enabled";
    private final String environment;
    private final Map transportConfiguration;
    private RuntimeEnvironment[] runningOn;

    public DefaultRuntimeEnvironmentProvider(Map transportConfiguration, String environment) {
        this.transportConfiguration = transportConfiguration;
        this.environment = environment;
    }

    @Override
    public RuntimeEnvironment[] getRuntimeEnvironment() {
        if (this.runningOn != null) {
            return this.runningOn;
        }
        ArrayList<RuntimeEnvironment> availableEnvironments = new ArrayList<RuntimeEnvironment>();
        try {
            Map websocketTransport;
            Map map = websocketTransport = this.transportConfiguration != null ? (Map)this.transportConfiguration.get(WEBSOCKET_TRANSPORT_CONFIG_KEY) : null;
            if (websocketTransport != null && !websocketTransport.isEmpty() && (websocketTransport.get(ENABLED_FIELD_NAME) == null || websocketTransport.get(ENABLED_FIELD_NAME) != null && ((Boolean)websocketTransport.get(ENABLED_FIELD_NAME)).booleanValue())) {
                if (StringUtils.isNotBlank((String)this.environment) && this.environment.equalsIgnoreCase(RuntimeEnvironment.ON_PREM.getValue())) {
                    availableEnvironments.add(RuntimeEnvironment.ON_PREM);
                } else {
                    availableEnvironments.add(RuntimeEnvironment.RUNTIME_MANAGER);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Couldn't retrieve the runtime environment. Error: {}", (Object)e.getMessage());
            LOGGER.debug("Error Stack:", (Throwable)e);
        }
        try {
            Map restTransport;
            Map map = restTransport = this.transportConfiguration != null ? (Map)this.transportConfiguration.get(REST_TRANSPORT_CONFIG_KEY) : null;
            if (restTransport != null && !restTransport.isEmpty() && restTransport.get(ENABLED_FIELD_NAME) != null && ((Boolean)restTransport.get(ENABLED_FIELD_NAME)).booleanValue() || availableEnvironments.isEmpty()) {
                availableEnvironments.add(RuntimeEnvironment.STANDALONE);
            }
        }
        catch (Exception e) {
            LOGGER.info("Couldn't retrieve the Standalone runtime environment. Error: {}", (Object)e.getMessage());
            LOGGER.debug("Error Stack:", (Throwable)e);
        }
        this.runningOn = availableEnvironments.toArray(new RuntimeEnvironment[0]);
        return this.runningOn;
    }
}

