/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.DefaultMethodPrimitiveInjector;
import com.mulesoft.agent.configuration.DefaultRuntimeEnvironmentProvider;
import com.mulesoft.agent.configuration.Environment;
import com.mulesoft.agent.configuration.PrimitiveInjector;
import com.mulesoft.agent.configuration.RequiredNamedAnnotationMatcher;
import com.mulesoft.agent.configuration.RuntimeEnvironmentProvider;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.configuration.descriptor.YamlMuleAgentDescriptor;
import com.mulesoft.agent.configuration.encryption.DefaultEncryptionService;
import com.mulesoft.agent.configuration.encryption.NullEncryptionService;
import com.mulesoft.agent.configuration.postconfigure.DefaultPostConfigureRunner;
import com.mulesoft.agent.configuration.postconfigure.PostConfigurableInjectorListener;
import com.mulesoft.agent.configuration.postconfigure.PostConfigureRunner;
import com.mulesoft.agent.configuration.properties.MasterPasswordProperty;
import com.mulesoft.agent.configuration.verifier.ConfigurationVerifier;
import com.mulesoft.agent.configuration.verifier.ConfiguredComponentsNotLoadedVerifier;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.transport.AgentTransport;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurablePropertyModule
extends AbstractModule {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String PASSWORD_PROPERTY = "mule.agent.configuration.password";
    public static final String MULE_AGENT_DESCRIPTOR_PLACEHOLDER = "${MULE_AGENT_DESCRIPTOR}";
    public static final String MULE_AGENT_LIB_PLACEHOLDER = "${MULE_AGENT_PLUGIN_LIB}";
    public static final String ENVIRONMENT_KEY = "environment";
    private final ConfigurationVerifier configurationVerifier;
    private final EncryptionService encryptionService;
    private final MuleAgentDescriptor muleAgentDescriptor;
    private final PostConfigureRunner postConfigureRunner;
    private final RuntimeEnvironmentProvider runtimeEnvironmentProvider;
    private Map transportsConfiguration;
    private Map internalHandlers;
    private Map externalHandlers;
    private Map servicesConfiguration;
    private Map globalConfiguration;
    private Map agentConfiguration;
    private String environment;

    public ConfigurablePropertyModule(String parentDescriptorName, String confFolder) {
        MasterPasswordProperty masterPassword = MasterPasswordProperty.newInstance(Environment.getInstance());
        this.encryptionService = masterPassword.isBlank() ? new NullEncryptionService() : new DefaultEncryptionService();
        this.postConfigureRunner = new DefaultPostConfigureRunner();
        this.muleAgentDescriptor = new YamlMuleAgentDescriptor(confFolder, parentDescriptorName, this.encryptionService);
        this.agentConfiguration = this.muleAgentDescriptor.load();
        this.globalConfiguration = this.getServiceConfiguration("globalConfiguration");
        this.servicesConfiguration = this.getServiceConfiguration("services");
        this.transportsConfiguration = this.getServiceConfiguration("transports");
        this.internalHandlers = this.getServiceConfiguration("internalHandlers");
        this.externalHandlers = this.getServiceConfiguration("externalHandlers");
        this.configurationVerifier = new ConfigurationVerifier(this.internalHandlers);
        this.configurationVerifier.addVerificationAlgorithm(new ConfiguredComponentsNotLoadedVerifier());
        this.environment = (String)this.agentConfiguration.get(ENVIRONMENT_KEY);
        this.runtimeEnvironmentProvider = new DefaultRuntimeEnvironmentProvider(this.transportsConfiguration, this.environment);
    }

    private Map getServiceConfiguration(String services) {
        Map map = (Map)this.agentConfiguration.get(services);
        if (map == null) {
            return new HashMap();
        }
        return map;
    }

    protected void configure() {
        this.bindListener((Matcher)new RequiredNamedAnnotationMatcher(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> literalType, TypeEncounter<I> encounter) {
                Class rawType = literalType.getRawType();
                Named annotation = rawType.getAnnotation(Named.class);
                String componentName = annotation.value();
                LOGGER.debug("Registering the component: '{}'.", (Object)componentName);
                encounter.register(new PostConfigurableInjectorListener(componentName, ConfigurablePropertyModule.this.postConfigureRunner));
                this.inspect(encounter, componentName, this.componentConfiguration(literalType, componentName), rawType);
                ConfigurablePropertyModule.this.configurationVerifier.addComponent(componentName, rawType);
            }

            private <I> void inspect(TypeEncounter<I> encounter, String componentName, Map configuration, Class clazz) {
                if (clazz.getSuperclass() != null) {
                    this.inspect(encounter, componentName, configuration, clazz.getSuperclass());
                }
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Configurable.class)) continue;
                    this.setValue(encounter, field, componentName, configuration);
                }
            }

            private <I> Map componentConfiguration(TypeLiteral<I> literalType, String componentName) {
                Map configuration = null;
                if (MuleAgentService.class.isAssignableFrom(literalType.getRawType())) {
                    configuration = (Map)ConfigurablePropertyModule.this.servicesConfiguration.get(componentName);
                } else if (AgentTransport.class.isAssignableFrom(literalType.getRawType())) {
                    configuration = (Map)ConfigurablePropertyModule.this.transportsConfiguration.get(componentName);
                } else if (InternalMessageHandler.class.isAssignableFrom(literalType.getRawType())) {
                    configuration = (Map)ConfigurablePropertyModule.this.internalHandlers.get(componentName);
                } else if (ExternalMessageHandler.class.isAssignableFrom(literalType.getRawType())) {
                    configuration = (Map)ConfigurablePropertyModule.this.externalHandlers.get(componentName);
                }
                return configuration;
            }

            private <I> void setValue(TypeEncounter<I> encounter, Field field, String componentName, Map serviceConfiguration) {
                field.setAccessible(true);
                Object descriptorValue = serviceConfiguration == null ? null : serviceConfiguration.get(field.getName());
                String systemPropertyValue = System.getProperty(String.format("%s.%s", componentName, field.getName()));
                String defaultValue = field.getAnnotation(Configurable.class).value();
                Object agentRootDescriptorValue = this.getRootConfiguration(componentName, field, null);
                if (systemPropertyValue != null) {
                    encounter.register(new PrimitiveInjector(field, ConfigurablePropertyModule.this.muleAgentDescriptor.getStringFieldValue(field, systemPropertyValue), componentName, ConfigurablePropertyModule.this.muleAgentDescriptor));
                } else if (descriptorValue != null) {
                    encounter.register(new PrimitiveInjector(field, ConfigurablePropertyModule.this.muleAgentDescriptor.getFieldValue(field, descriptorValue), componentName, ConfigurablePropertyModule.this.muleAgentDescriptor));
                } else if (agentRootDescriptorValue != null) {
                    encounter.register(new PrimitiveInjector(field, ConfigurablePropertyModule.this.muleAgentDescriptor.getFieldValue(field, agentRootDescriptorValue), componentName, ConfigurablePropertyModule.this.muleAgentDescriptor));
                } else if (field.getName().equals(ConfigurablePropertyModule.ENVIRONMENT_KEY)) {
                    encounter.register(new PrimitiveInjector(field, ConfigurablePropertyModule.this.muleAgentDescriptor.getStringFieldValue(field, ConfigurablePropertyModule.this.environment), componentName, ConfigurablePropertyModule.this.muleAgentDescriptor));
                } else if (defaultValue.length() > 0 || field.getAnnotation(Configurable.class).method().length() > 0) {
                    encounter.register(new DefaultMethodPrimitiveInjector(field, ConfigurablePropertyModule.this.muleAgentDescriptor.getStringFieldValue(field, defaultValue), componentName, ConfigurablePropertyModule.this.muleAgentDescriptor));
                }
            }

            private Object getRootConfiguration(String componentName, Field field, Map configurarionMap) {
                String fieldSystemValue = System.getProperty(String.format("%s.%s", componentName, field.getName()));
                if (fieldSystemValue != null) {
                    return fieldSystemValue;
                }
                Object mainConfiguration = ConfigurablePropertyModule.this.globalConfiguration.get(field.getName());
                if (mainConfiguration == null && configurarionMap != null) {
                    mainConfiguration = configurarionMap.get(field.getName());
                }
                if (mainConfiguration != null && Map.class.isAssignableFrom(mainConfiguration.getClass())) {
                    Map mappedConfiguration = (Map)mainConfiguration;
                    for (Field innerField : field.getType().getDeclaredFields()) {
                        if (innerField.getAnnotation(Configurable.class) == null) continue;
                        if (mappedConfiguration.get(innerField.getName()) == null) {
                            mappedConfiguration.put(innerField.getName(), this.getRootConfiguration(field.getName(), innerField, mappedConfiguration));
                            continue;
                        }
                        if (Map.class.isAssignableFrom(mappedConfiguration.get(innerField.getName()).getClass())) {
                            mappedConfiguration.put(innerField.getName(), this.getRootConfiguration(field.getName(), innerField, mappedConfiguration));
                            continue;
                        }
                        mappedConfiguration.put(innerField.getName(), ConfigurablePropertyModule.this.muleAgentDescriptor.getFieldValue(innerField, mappedConfiguration.get(innerField.getName())));
                    }
                }
                return mainConfiguration;
            }
        });
        this.bind(MuleAgentDescriptor.class).toInstance((Object)this.muleAgentDescriptor);
    }

    public List<String> getConfigurationErrors() {
        return this.configurationVerifier.getConfigurationErrors();
    }

    public RuntimeEnvironmentProvider getRuntimeEnvironmentProvider() {
        return this.runtimeEnvironmentProvider;
    }
}

