/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal;

import com.mulesoft.mule.runtime.cache.api.CachingStrategy;
import com.mulesoft.mule.runtime.cache.internal.ObjectStoreCachingStrategy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class CachingMessageProcessor
extends AbstractMessageProcessorOwner
implements Processor,
Initialisable,
Startable,
Stoppable {
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ComponentTracerFactory componentTracerFactory;
    private List<Processor> processors;
    private Processor cachedMessageProcessor;
    private boolean cachingStrategyDefault = false;
    private CachingStrategy cachingStrategy;
    private String filterExpression = Boolean.toString(true);

    public void initialise() throws InitialisationException {
        this.cachedMessageProcessor = MessageProcessors.buildNewChainWithListOfProcessors((Optional)MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this), this.processors, (FlowExceptionHandler)NullExceptionHandler.getInstance(), (String)this.getLocation().getLocation(), (ComponentTracer)this.componentTracerFactory.fromComponent((Component)this, "mule:cache-chain", ""));
        super.initialise();
        if (this.cachingStrategy == null) {
            this.cachingStrategyDefault = true;
            this.cachingStrategy = this.createDefaultCachingStrategy();
            LifecycleUtils.initialiseIfNeeded((Object)this.cachingStrategy);
        }
    }

    public void start() throws MuleException {
        super.start();
        if (this.cachingStrategyDefault) {
            LifecycleUtils.startIfNeeded((Object)this.cachingStrategy);
        }
    }

    public void stop() throws MuleException {
        if (this.cachingStrategyDefault) {
            LifecycleUtils.stopIfNeeded((Object)this.cachingStrategy);
        }
        super.stop();
    }

    protected CachingStrategy createDefaultCachingStrategy() {
        ObjectStoreCachingStrategy objectStoreCachingStrategy = new ObjectStoreCachingStrategy();
        objectStoreCachingStrategy.setLockFactory(this.lockFactory);
        objectStoreCachingStrategy.setMuleContext(this.muleContext);
        objectStoreCachingStrategy.setObjectStoreManager(this.objectStoreManager);
        objectStoreCachingStrategy.setSchedulerService(this.schedulerService);
        objectStoreCachingStrategy.setName(this.getLocation().getLocation());
        return objectStoreCachingStrategy;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).flatMap(event -> Flux.deferContextual(ctx -> {
            Processor contextPropagatingProcessor = new Processor(){
                final /* synthetic */ ContextView val$ctx;
                {
                    this.val$ctx = contextView;
                }

                public Publisher<CoreEvent> apply(Publisher<CoreEvent> t) {
                    return Flux.from(t).transform((Function)CachingMessageProcessor.this.cachedMessageProcessor).contextWrite(innerCtx -> innerCtx.put((Object)"messageProcessors.withinProcessToApply", (Object)true)).contextWrite(this.val$ctx);
                }

                public CoreEvent process(CoreEvent event) throws MuleException {
                    return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)CachingMessageProcessor.this.cachedMessageProcessor);
                }
            };
            if (this.expressionManager.evaluateBoolean(this.filterExpression, event, this.getLocation(), false, true)) {
                return Mono.just((Object)event).transform((Function)this.cachingStrategy.transformProcessor(contextPropagatingProcessor));
            }
            return Mono.just((Object)event).transform((Function)contextPropagatingProcessor);
        }));
    }

    public void setMessageProcessors(List<Processor> messageProcessors) throws MuleException {
        this.processors = messageProcessors;
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.cachedMessageProcessor);
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public void setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = CachingStrategy.checkInternalUse(cachingStrategy);
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }
}

